/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.stellar.sdk.Address;
import org.stellar.sdk.KeyPair;
import org.stellar.sdk.Network;
import org.stellar.sdk.Util;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.scval.Scv;
import org.stellar.sdk.xdr.EnvelopeType;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.HashIDPreimage;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SorobanAddressCredentials;
import org.stellar.sdk.xdr.SorobanAuthorizationEntry;
import org.stellar.sdk.xdr.SorobanAuthorizedInvocation;
import org.stellar.sdk.xdr.SorobanCredentials;
import org.stellar.sdk.xdr.SorobanCredentialsType;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public class Auth {
    public static SorobanAuthorizationEntry authorizeEntry(String entry, KeyPair signer, Long validUntilLedgerSeq, Network network) {
        SorobanAuthorizationEntry entryXdr;
        try {
            entryXdr = SorobanAuthorizationEntry.fromXdrBase64(entry);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert entry to SorobanAuthorizationEntry", e);
        }
        return Auth.authorizeEntry(entryXdr, signer, validUntilLedgerSeq, network);
    }

    public static SorobanAuthorizationEntry authorizeEntry(SorobanAuthorizationEntry entry, KeyPair signer, Long validUntilLedgerSeq, Network network) {
        Signer entrySigner = preimage -> {
            byte[] data;
            try {
                data = preimage.toXdrByteArray();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Unable to convert preimage to bytes", e);
            }
            byte[] payload = Util.hash(data);
            return signer.sign(payload);
        };
        return Auth.authorizeEntry(entry, entrySigner, validUntilLedgerSeq, network);
    }

    public static SorobanAuthorizationEntry authorizeEntry(String entry, Signer signer, Long validUntilLedgerSeq, Network network) {
        SorobanAuthorizationEntry entryXdr;
        try {
            entryXdr = SorobanAuthorizationEntry.fromXdrBase64(entry);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert entry to SorobanAuthorizationEntry", e);
        }
        return Auth.authorizeEntry(entryXdr, signer, validUntilLedgerSeq, network);
    }

    public static SorobanAuthorizationEntry authorizeEntry(SorobanAuthorizationEntry entry, Signer signer, Long validUntilLedgerSeq, Network network) {
        byte[] data;
        SorobanAuthorizationEntry clone;
        try {
            clone = SorobanAuthorizationEntry.fromXdrByteArray(entry.toXdrByteArray());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to clone SorobanAuthorizationEntry", e);
        }
        if (clone.getCredentials().getDiscriminant() != SorobanCredentialsType.SOROBAN_CREDENTIALS_ADDRESS) {
            return clone;
        }
        SorobanAddressCredentials addressCredentials = clone.getCredentials().getAddress();
        addressCredentials.setSignatureExpirationLedger(new Uint32(new XdrUnsignedInteger(validUntilLedgerSeq)));
        HashIDPreimage preimage = HashIDPreimage.builder().discriminant(EnvelopeType.ENVELOPE_TYPE_SOROBAN_AUTHORIZATION).sorobanAuthorization(HashIDPreimage.HashIDPreimageSorobanAuthorization.builder().networkID(new Hash(network.getNetworkId())).nonce(addressCredentials.getNonce()).invocation(clone.getRootInvocation()).signatureExpirationLedger(addressCredentials.getSignatureExpirationLedger()).build()).build();
        final byte[] signature = signer.sign(preimage);
        final byte[] publicKey = Address.fromSCAddress(addressCredentials.getAddress()).getBytes();
        try {
            data = preimage.toXdrByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to convert preimage to bytes", e);
        }
        byte[] payload = Util.hash(data);
        if (!KeyPair.fromPublicKey(publicKey).verify(payload, signature)) {
            throw new IllegalArgumentException("signature does not match payload");
        }
        SCVal sigScVal = Scv.toMap(new LinkedHashMap<SCVal, SCVal>(){
            {
                this.put(Scv.toSymbol("public_key"), Scv.toBytes(publicKey));
                this.put(Scv.toSymbol("signature"), Scv.toBytes(signature));
            }
        });
        addressCredentials.setSignature(Scv.toVec(Collections.singleton(sigScVal)));
        return clone;
    }

    public static SorobanAuthorizationEntry authorizeInvocation(KeyPair signer, Long validUntilLedgerSeq, SorobanAuthorizedInvocation invocation, Network network) {
        Signer entrySigner = preimage -> {
            try {
                byte[] payload = Util.hash(preimage.toXdrByteArray());
                return signer.sign(payload);
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        };
        return Auth.authorizeInvocation(entrySigner, signer.getAccountId(), validUntilLedgerSeq, invocation, network);
    }

    public static SorobanAuthorizationEntry authorizeInvocation(Signer signer, String publicKey, Long validUntilLedgerSeq, SorobanAuthorizedInvocation invocation, Network network) {
        long nonce = new SecureRandom().nextLong();
        SorobanAuthorizationEntry entry = SorobanAuthorizationEntry.builder().credentials(SorobanCredentials.builder().discriminant(SorobanCredentialsType.SOROBAN_CREDENTIALS_ADDRESS).address(SorobanAddressCredentials.builder().address(new Address(publicKey).toSCAddress()).nonce(new Int64(nonce)).signatureExpirationLedger(new Uint32(new XdrUnsignedInteger(validUntilLedgerSeq))).signature(Scv.toVoid()).build()).build()).rootInvocation(invocation).build();
        return Auth.authorizeEntry(entry, signer, validUntilLedgerSeq, network);
    }

    public static interface Signer {
        public byte[] sign(HashIDPreimage var1);
    }
}

