/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import lombok.Generated;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public final class LedgerBounds {
    private final long minLedger;
    private final long maxLedger;

    public LedgerBounds(long minLedger, long maxLedger) {
        if (minLedger < 0L || minLedger > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("minLedger must be between 0 and 2^32-1");
        }
        if (maxLedger < 0L || maxLedger > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("maxLedger must be between 0 and 2^32-1");
        }
        if (maxLedger > 0L && minLedger > maxLedger) {
            throw new IllegalArgumentException("minLedger can not be greater than maxLedger");
        }
        this.minLedger = minLedger;
        this.maxLedger = maxLedger;
    }

    public static LedgerBounds fromXdr(org.stellar.sdk.xdr.LedgerBounds xdrLedgerBounds) {
        return new LedgerBounds(xdrLedgerBounds.getMinLedger().getUint32().getNumber(), xdrLedgerBounds.getMaxLedger().getUint32().getNumber());
    }

    public org.stellar.sdk.xdr.LedgerBounds toXdr() {
        return org.stellar.sdk.xdr.LedgerBounds.builder().maxLedger(new Uint32(new XdrUnsignedInteger(this.maxLedger))).minLedger(new Uint32(new XdrUnsignedInteger(this.minLedger))).build();
    }

    @Generated
    public long getMinLedger() {
        return this.minLedger;
    }

    @Generated
    public long getMaxLedger() {
        return this.maxLedger;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerBounds)) {
            return false;
        }
        LedgerBounds other = (LedgerBounds)o;
        if (this.getMinLedger() != other.getMinLedger()) {
            return false;
        }
        return this.getMaxLedger() == other.getMaxLedger();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minLedger = this.getMinLedger();
        result = result * 59 + (int)($minLedger >>> 32 ^ $minLedger);
        long $maxLedger = this.getMaxLedger();
        result = result * 59 + (int)($maxLedger >>> 32 ^ $maxLedger);
        return result;
    }

    @Generated
    public String toString() {
        return "LedgerBounds(minLedger=" + this.getMinLedger() + ", maxLedger=" + this.getMaxLedger() + ")";
    }
}

