/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Util;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.xdr.Int32;
import org.stellar.sdk.xdr.LiquidityPoolConstantProductParameters;
import org.stellar.sdk.xdr.LiquidityPoolParameters;
import org.stellar.sdk.xdr.LiquidityPoolType;

public final class LiquidityPool {
    public static int FEE = 30;
    @NonNull
    private final Asset assetA;
    @NonNull
    private final Asset assetB;
    private final int fee;

    private LiquidityPool(@NonNull Asset assetA, @NonNull Asset assetB, int fee) {
        if (assetA == null) {
            throw new NullPointerException("assetA is marked non-null but is null");
        }
        if (assetB == null) {
            throw new NullPointerException("assetB is marked non-null but is null");
        }
        if (assetA.compareTo(assetB) >= 0) {
            throw new IllegalArgumentException("Assets are not in lexicographic order");
        }
        this.assetA = assetA;
        this.assetB = assetB;
        this.fee = fee;
    }

    public LiquidityPool(Asset assetA, Asset assetB) {
        this(assetA, assetB, FEE);
    }

    public LiquidityPoolParameters toXdr() {
        LiquidityPoolParameters xdr = new LiquidityPoolParameters();
        xdr.setDiscriminant(LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT);
        LiquidityPoolConstantProductParameters params = new LiquidityPoolConstantProductParameters();
        params.setAssetA(this.assetA.toXdr());
        params.setAssetB(this.assetB.toXdr());
        params.setFee(new Int32(this.fee));
        xdr.setConstantProduct(params);
        return xdr;
    }

    public static LiquidityPool fromXdr(LiquidityPoolParameters xdr) {
        if (xdr.getDiscriminant() != LiquidityPoolType.LIQUIDITY_POOL_CONSTANT_PRODUCT) {
            throw new IllegalArgumentException(String.format("Invalid LiquidityPoolType: %s", xdr.getDiscriminant()));
        }
        LiquidityPoolConstantProductParameters parameters = xdr.getConstantProduct();
        return new LiquidityPool(Asset.fromXdr(parameters.getAssetA()), Asset.fromXdr(parameters.getAssetB()), parameters.getFee().getInt32());
    }

    public String getLiquidityPoolId() {
        LiquidityPoolParameters liquidityPoolParameters = this.toXdr();
        try {
            byte[] poolId = Util.hash(liquidityPoolParameters.toXdrByteArray());
            return Util.bytesToHex(poolId).toLowerCase();
        }
        catch (IOException e) {
            throw new UnexpectedException(e);
        }
    }

    @NonNull
    @Generated
    public Asset getAssetA() {
        return this.assetA;
    }

    @NonNull
    @Generated
    public Asset getAssetB() {
        return this.assetB;
    }

    @Generated
    public int getFee() {
        return this.fee;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LiquidityPool)) {
            return false;
        }
        LiquidityPool other = (LiquidityPool)o;
        if (this.getFee() != other.getFee()) {
            return false;
        }
        Asset this$assetA = this.getAssetA();
        Asset other$assetA = other.getAssetA();
        if (this$assetA == null ? other$assetA != null : !((Object)this$assetA).equals(other$assetA)) {
            return false;
        }
        Asset this$assetB = this.getAssetB();
        Asset other$assetB = other.getAssetB();
        return !(this$assetB == null ? other$assetB != null : !((Object)this$assetB).equals(other$assetB));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFee();
        Asset $assetA = this.getAssetA();
        result = result * 59 + ($assetA == null ? 43 : $assetA.hashCode());
        Asset $assetB = this.getAssetB();
        result = result * 59 + ($assetB == null ? 43 : $assetB.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LiquidityPool(assetA=" + this.getAssetA() + ", assetB=" + this.getAssetB() + ", fee=" + this.getFee() + ")";
    }
}

