/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.math.BigDecimal;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.Util;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.ClawbackOp;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class ClawbackOperation
extends Operation {
    @NonNull
    private final String from;
    @NonNull
    private final Asset asset;
    @NonNull
    private final BigDecimal amount;

    public static ClawbackOperation fromXdr(ClawbackOp op) {
        String from = StrKey.encodeMuxedAccount(op.getFrom());
        BigDecimal amount = Operation.fromXdrAmount(op.getAmount().getInt64());
        AssetTypeCreditAlphaNum asset = Util.assertNonNativeAsset(Asset.fromXdr(op.getAsset()));
        return new ClawbackOperation(from, asset, amount);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ClawbackOp op = new ClawbackOp();
        op.setFrom(StrKey.encodeToXDRMuxedAccount(this.from));
        Int64 amount = new Int64();
        amount.setInt64(Operation.toXdrAmount(this.amount));
        op.setAmount(amount);
        op.setAsset(this.asset.toXdr());
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CLAWBACK);
        body.setClawbackOp(op);
        return body;
    }

    @Generated
    protected ClawbackOperation(ClawbackOperationBuilder<?, ?> b) {
        super(b);
        this.from = ((ClawbackOperationBuilder)b).from;
        if (this.from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        this.asset = ((ClawbackOperationBuilder)b).asset;
        if (this.asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        this.amount = ((ClawbackOperationBuilder)b).amount;
        if (this.amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
    }

    @Generated
    public static ClawbackOperationBuilder<?, ?> builder() {
        return new ClawbackOperationBuilderImpl();
    }

    @Generated
    public ClawbackOperationBuilder<?, ?> toBuilder() {
        return new ClawbackOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getFrom() {
        return this.from;
    }

    @NonNull
    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @NonNull
    @Generated
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Generated
    public String toString() {
        return "ClawbackOperation(super=" + super.toString() + ", from=" + this.getFrom() + ", asset=" + this.getAsset() + ", amount=" + this.getAmount() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClawbackOperation)) {
            return false;
        }
        ClawbackOperation other = (ClawbackOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        if (this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset)) {
            return false;
        }
        BigDecimal this$amount = this.getAmount();
        BigDecimal other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClawbackOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
        BigDecimal $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    @Generated
    private ClawbackOperation(@NonNull String from, @NonNull Asset asset, @NonNull BigDecimal amount) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (asset == null) {
            throw new NullPointerException("asset is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.from = from;
        this.asset = asset;
        this.amount = amount;
    }

    public static abstract class ClawbackOperationBuilder<C extends ClawbackOperation, B extends ClawbackOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String from;
        @Generated
        private Asset asset;
        @Generated
        private BigDecimal amount;

        public B amount(@NonNull BigDecimal amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = Operation.formatAmountScale(amount);
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ClawbackOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ClawbackOperation instance, ClawbackOperationBuilder<?, ?> b) {
            b.from(instance.from);
            b.asset(instance.asset);
            b.amount(instance.amount);
        }

        @Generated
        public B from(@NonNull String from) {
            if (from == null) {
                throw new NullPointerException("from is marked non-null but is null");
            }
            this.from = from;
            return (B)this.self();
        }

        @Generated
        public B asset(@NonNull Asset asset) {
            if (asset == null) {
                throw new NullPointerException("asset is marked non-null but is null");
            }
            this.asset = asset;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ClawbackOperation.ClawbackOperationBuilder(super=" + super.toString() + ", from=" + this.from + ", asset=" + this.asset + ", amount=" + this.amount + ")";
        }
    }

    private static final class ClawbackOperationBuilderImpl
    extends ClawbackOperationBuilder<ClawbackOperation, ClawbackOperationBuilderImpl> {
        @Override
        public ClawbackOperation build() {
            ClawbackOperation op = new ClawbackOperation(this);
            if (!(op.asset instanceof AssetTypeCreditAlphaNum)) {
                throw new IllegalArgumentException("native assets are not supported");
            }
            return op;
        }

        @Generated
        private ClawbackOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected ClawbackOperationBuilderImpl self() {
            return this;
        }
    }
}

