/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.Address;
import org.stellar.sdk.Asset;
import org.stellar.sdk.Util;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.ContractExecutable;
import org.stellar.sdk.xdr.ContractExecutableType;
import org.stellar.sdk.xdr.ContractIDPreimage;
import org.stellar.sdk.xdr.ContractIDPreimageType;
import org.stellar.sdk.xdr.CreateContractArgs;
import org.stellar.sdk.xdr.Hash;
import org.stellar.sdk.xdr.HostFunction;
import org.stellar.sdk.xdr.HostFunctionType;
import org.stellar.sdk.xdr.InvokeContractArgs;
import org.stellar.sdk.xdr.InvokeHostFunctionOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.SCSymbol;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SorobanAuthorizationEntry;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrString;

public class InvokeHostFunctionOperation
extends Operation {
    @NonNull
    private final HostFunction hostFunction;
    @NonNull
    private final List<SorobanAuthorizationEntry> auth;

    public static InvokeHostFunctionOperation fromXdr(InvokeHostFunctionOp op) {
        return ((InvokeHostFunctionOperationBuilder)((InvokeHostFunctionOperationBuilder)InvokeHostFunctionOperation.builder().hostFunction(op.getHostFunction())).auth(Arrays.asList(op.getAuth()))).build();
    }

    public static InvokeHostFunctionOperationBuilder<?, ?> uploadContractWasmOperationBuilder(byte[] wasm) {
        HostFunction hostFunction = HostFunction.builder().discriminant(HostFunctionType.HOST_FUNCTION_TYPE_UPLOAD_CONTRACT_WASM).wasm(wasm).build();
        return InvokeHostFunctionOperation.builder().hostFunction(hostFunction);
    }

    public static InvokeHostFunctionOperationBuilder<?, ?> createContractOperationBuilder(String wasmId, Address address, @Nullable byte[] salt) {
        byte[] wasmIdBytes = Util.hexToBytes(wasmId);
        return InvokeHostFunctionOperation.createContractOperationBuilder(wasmIdBytes, address, salt);
    }

    public static InvokeHostFunctionOperationBuilder<?, ?> createContractOperationBuilder(byte[] wasmId, Address address, @Nullable byte[] salt) {
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
        } else if (salt.length != 32) {
            throw new IllegalArgumentException("\"salt\" must be 32 bytes long");
        }
        if (wasmId.length != 32) {
            throw new IllegalArgumentException("\"wasmId\" must be 32 bytes long");
        }
        CreateContractArgs createContractArgs = CreateContractArgs.builder().contractIDPreimage(ContractIDPreimage.builder().discriminant(ContractIDPreimageType.CONTRACT_ID_PREIMAGE_FROM_ADDRESS).fromAddress(ContractIDPreimage.ContractIDPreimageFromAddress.builder().address(address.toSCAddress()).salt(new Uint256(salt)).build()).build()).executable(ContractExecutable.builder().discriminant(ContractExecutableType.CONTRACT_EXECUTABLE_WASM).wasm_hash(new Hash(wasmId)).build()).build();
        HostFunction hostFunction = HostFunction.builder().discriminant(HostFunctionType.HOST_FUNCTION_TYPE_CREATE_CONTRACT).createContract(createContractArgs).build();
        return InvokeHostFunctionOperation.builder().hostFunction(hostFunction);
    }

    public static InvokeHostFunctionOperationBuilder<?, ?> createStellarAssetContractOperationBuilder(Asset asset) {
        CreateContractArgs createContractArgs = CreateContractArgs.builder().contractIDPreimage(ContractIDPreimage.builder().discriminant(ContractIDPreimageType.CONTRACT_ID_PREIMAGE_FROM_ASSET).fromAsset(asset.toXdr()).build()).executable(ContractExecutable.builder().discriminant(ContractExecutableType.CONTRACT_EXECUTABLE_STELLAR_ASSET).build()).build();
        HostFunction hostFunction = HostFunction.builder().discriminant(HostFunctionType.HOST_FUNCTION_TYPE_CREATE_CONTRACT).createContract(createContractArgs).build();
        return InvokeHostFunctionOperation.builder().hostFunction(hostFunction);
    }

    public static InvokeHostFunctionOperationBuilder<?, ?> createStellarAssetContractOperationBuilder(Address address, @Nullable byte[] salt) {
        if (salt == null) {
            salt = new byte[32];
            new SecureRandom().nextBytes(salt);
        } else if (salt.length != 32) {
            throw new IllegalArgumentException("\"salt\" must be 32 bytes long");
        }
        CreateContractArgs createContractArgs = CreateContractArgs.builder().contractIDPreimage(ContractIDPreimage.builder().discriminant(ContractIDPreimageType.CONTRACT_ID_PREIMAGE_FROM_ADDRESS).fromAddress(ContractIDPreimage.ContractIDPreimageFromAddress.builder().address(address.toSCAddress()).salt(new Uint256(salt)).build()).build()).executable(ContractExecutable.builder().discriminant(ContractExecutableType.CONTRACT_EXECUTABLE_STELLAR_ASSET).build()).build();
        HostFunction hostFunction = HostFunction.builder().discriminant(HostFunctionType.HOST_FUNCTION_TYPE_CREATE_CONTRACT).createContract(createContractArgs).build();
        return InvokeHostFunctionOperation.builder().hostFunction(hostFunction);
    }

    public static InvokeHostFunctionOperationBuilder<?, ?> invokeContractFunctionOperationBuilder(String contractId, String functionName, @Nullable Collection<SCVal> parameters) {
        Address address = new Address(contractId);
        if (address.getAddressType() != Address.AddressType.CONTRACT) {
            throw new IllegalArgumentException("\"contractId\" must be a contract address");
        }
        SCSymbol functionNameSCSymbol = new SCSymbol(new XdrString(functionName));
        ArrayList<SCVal> invokeContractParams = new ArrayList<SCVal>(parameters != null ? parameters.size() : 0);
        if (parameters != null) {
            for (SCVal parameter : parameters) {
                if (parameter == null) {
                    throw new IllegalArgumentException("\"parameters\" contains null element");
                }
                invokeContractParams.add(parameter);
            }
        }
        InvokeContractArgs invokeContractArgs = InvokeContractArgs.builder().contractAddress(address.toSCAddress()).functionName(functionNameSCSymbol).args(invokeContractParams.toArray(new SCVal[0])).build();
        HostFunction hostFunction = HostFunction.builder().discriminant(HostFunctionType.HOST_FUNCTION_TYPE_INVOKE_CONTRACT).invokeContract(invokeContractArgs).build();
        return InvokeHostFunctionOperation.builder().hostFunction(hostFunction);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        InvokeHostFunctionOp op = new InvokeHostFunctionOp();
        op.setHostFunction(this.hostFunction);
        op.setAuth(this.auth.toArray(new SorobanAuthorizationEntry[0]));
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.INVOKE_HOST_FUNCTION);
        body.setInvokeHostFunctionOp(op);
        return body;
    }

    @Generated
    private static List<SorobanAuthorizationEntry> $default$auth() {
        return new ArrayList<SorobanAuthorizationEntry>();
    }

    @Generated
    protected InvokeHostFunctionOperation(InvokeHostFunctionOperationBuilder<?, ?> b) {
        super(b);
        this.hostFunction = ((InvokeHostFunctionOperationBuilder)b).hostFunction;
        if (this.hostFunction == null) {
            throw new NullPointerException("hostFunction is marked non-null but is null");
        }
        this.auth = ((InvokeHostFunctionOperationBuilder)b).auth$set ? ((InvokeHostFunctionOperationBuilder)b).auth$value : InvokeHostFunctionOperation.$default$auth();
        if (this.auth == null) {
            throw new NullPointerException("auth is marked non-null but is null");
        }
    }

    @Generated
    public static InvokeHostFunctionOperationBuilder<?, ?> builder() {
        return new InvokeHostFunctionOperationBuilderImpl();
    }

    @Generated
    public InvokeHostFunctionOperationBuilder<?, ?> toBuilder() {
        return new InvokeHostFunctionOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public HostFunction getHostFunction() {
        return this.hostFunction;
    }

    @NonNull
    @Generated
    public List<SorobanAuthorizationEntry> getAuth() {
        return this.auth;
    }

    @Generated
    public String toString() {
        return "InvokeHostFunctionOperation(super=" + super.toString() + ", hostFunction=" + this.getHostFunction() + ", auth=" + this.getAuth() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvokeHostFunctionOperation)) {
            return false;
        }
        InvokeHostFunctionOperation other = (InvokeHostFunctionOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HostFunction this$hostFunction = this.getHostFunction();
        HostFunction other$hostFunction = other.getHostFunction();
        if (this$hostFunction == null ? other$hostFunction != null : !((Object)this$hostFunction).equals(other$hostFunction)) {
            return false;
        }
        List<SorobanAuthorizationEntry> this$auth = this.getAuth();
        List<SorobanAuthorizationEntry> other$auth = other.getAuth();
        return !(this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvokeHostFunctionOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HostFunction $hostFunction = this.getHostFunction();
        result = result * 59 + ($hostFunction == null ? 43 : ((Object)$hostFunction).hashCode());
        List<SorobanAuthorizationEntry> $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
        return result;
    }

    @Generated
    private InvokeHostFunctionOperation(@NonNull HostFunction hostFunction, @NonNull List<SorobanAuthorizationEntry> auth) {
        if (hostFunction == null) {
            throw new NullPointerException("hostFunction is marked non-null but is null");
        }
        if (auth == null) {
            throw new NullPointerException("auth is marked non-null but is null");
        }
        this.hostFunction = hostFunction;
        this.auth = auth;
    }

    @Generated
    public static abstract class InvokeHostFunctionOperationBuilder<C extends InvokeHostFunctionOperation, B extends InvokeHostFunctionOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private HostFunction hostFunction;
        @Generated
        private boolean auth$set;
        @Generated
        private List<SorobanAuthorizationEntry> auth$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            InvokeHostFunctionOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(InvokeHostFunctionOperation instance, InvokeHostFunctionOperationBuilder<?, ?> b) {
            b.hostFunction(instance.hostFunction);
            b.auth(instance.auth);
        }

        @Generated
        public B hostFunction(@NonNull HostFunction hostFunction) {
            if (hostFunction == null) {
                throw new NullPointerException("hostFunction is marked non-null but is null");
            }
            this.hostFunction = hostFunction;
            return (B)this.self();
        }

        @Generated
        public B auth(@NonNull List<SorobanAuthorizationEntry> auth) {
            if (auth == null) {
                throw new NullPointerException("auth is marked non-null but is null");
            }
            this.auth$value = auth;
            this.auth$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "InvokeHostFunctionOperation.InvokeHostFunctionOperationBuilder(super=" + super.toString() + ", hostFunction=" + this.hostFunction + ", auth$value=" + this.auth$value + ")";
        }
    }

    @Generated
    private static final class InvokeHostFunctionOperationBuilderImpl
    extends InvokeHostFunctionOperationBuilder<InvokeHostFunctionOperation, InvokeHostFunctionOperationBuilderImpl> {
        @Generated
        private InvokeHostFunctionOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected InvokeHostFunctionOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public InvokeHostFunctionOperation build() {
            return new InvokeHostFunctionOperation(this);
        }
    }
}

