/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.responses.OrderBookResponse;

public class OrderBookRequestBuilder
extends RequestBuilder {
    public OrderBookRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "order_book");
    }

    public OrderBookRequestBuilder buyingAsset(Asset asset) {
        this.uriBuilder.setQueryParameter("buying_asset_type", OrderBookRequestBuilder.getAssetType(asset));
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAlphaNumAsset = (AssetTypeCreditAlphaNum)asset;
            this.uriBuilder.setQueryParameter("buying_asset_code", creditAlphaNumAsset.getCode());
            this.uriBuilder.setQueryParameter("buying_asset_issuer", creditAlphaNumAsset.getIssuer());
        }
        return this;
    }

    public OrderBookRequestBuilder sellingAsset(Asset asset) {
        this.uriBuilder.setQueryParameter("selling_asset_type", OrderBookRequestBuilder.getAssetType(asset));
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAlphaNumAsset = (AssetTypeCreditAlphaNum)asset;
            this.uriBuilder.setQueryParameter("selling_asset_code", creditAlphaNumAsset.getCode());
            this.uriBuilder.setQueryParameter("selling_asset_issuer", creditAlphaNumAsset.getIssuer());
        }
        return this;
    }

    public static OrderBookResponse execute(OkHttpClient httpClient, HttpUrl uri) {
        TypeToken<OrderBookResponse> type = new TypeToken<OrderBookResponse>(){};
        return OrderBookRequestBuilder.executeGetRequest(httpClient, uri, type);
    }

    public SSEStream<OrderBookResponse> stream(EventListener<OrderBookResponse> listener, long reconnectTimeout) {
        return SSEStream.create(this.httpClient, this, OrderBookResponse.class, listener, reconnectTimeout);
    }

    public SSEStream<OrderBookResponse> stream(EventListener<OrderBookResponse> listener) {
        return this.stream(listener, 15000L);
    }

    public OrderBookResponse execute() {
        return OrderBookRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public RequestBuilder cursor(String cursor) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public RequestBuilder order(RequestBuilder.Order direction) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }
}

