/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.sorobanrpc;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.DiagnosticEvent;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionMeta;
import org.stellar.sdk.xdr.TransactionResult;

public final class GetTransactionsResponse {
    private final List<Transaction> transactions;
    private final Long latestLedger;
    private final Long latestLedgerCloseTimestamp;
    private final Long oldestLedger;
    private final Long oldestLedgerCloseTimestamp;
    private final String cursor;

    @Generated
    public GetTransactionsResponse(List<Transaction> transactions, Long latestLedger, Long latestLedgerCloseTimestamp, Long oldestLedger, Long oldestLedgerCloseTimestamp, String cursor) {
        this.transactions = transactions;
        this.latestLedger = latestLedger;
        this.latestLedgerCloseTimestamp = latestLedgerCloseTimestamp;
        this.oldestLedger = oldestLedger;
        this.oldestLedgerCloseTimestamp = oldestLedgerCloseTimestamp;
        this.cursor = cursor;
    }

    @Generated
    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    @Generated
    public Long getLatestLedger() {
        return this.latestLedger;
    }

    @Generated
    public Long getLatestLedgerCloseTimestamp() {
        return this.latestLedgerCloseTimestamp;
    }

    @Generated
    public Long getOldestLedger() {
        return this.oldestLedger;
    }

    @Generated
    public Long getOldestLedgerCloseTimestamp() {
        return this.oldestLedgerCloseTimestamp;
    }

    @Generated
    public String getCursor() {
        return this.cursor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetTransactionsResponse)) {
            return false;
        }
        GetTransactionsResponse other = (GetTransactionsResponse)o;
        Long this$latestLedger = this.getLatestLedger();
        Long other$latestLedger = other.getLatestLedger();
        if (this$latestLedger == null ? other$latestLedger != null : !((Object)this$latestLedger).equals(other$latestLedger)) {
            return false;
        }
        Long this$latestLedgerCloseTimestamp = this.getLatestLedgerCloseTimestamp();
        Long other$latestLedgerCloseTimestamp = other.getLatestLedgerCloseTimestamp();
        if (this$latestLedgerCloseTimestamp == null ? other$latestLedgerCloseTimestamp != null : !((Object)this$latestLedgerCloseTimestamp).equals(other$latestLedgerCloseTimestamp)) {
            return false;
        }
        Long this$oldestLedger = this.getOldestLedger();
        Long other$oldestLedger = other.getOldestLedger();
        if (this$oldestLedger == null ? other$oldestLedger != null : !((Object)this$oldestLedger).equals(other$oldestLedger)) {
            return false;
        }
        Long this$oldestLedgerCloseTimestamp = this.getOldestLedgerCloseTimestamp();
        Long other$oldestLedgerCloseTimestamp = other.getOldestLedgerCloseTimestamp();
        if (this$oldestLedgerCloseTimestamp == null ? other$oldestLedgerCloseTimestamp != null : !((Object)this$oldestLedgerCloseTimestamp).equals(other$oldestLedgerCloseTimestamp)) {
            return false;
        }
        List<Transaction> this$transactions = this.getTransactions();
        List<Transaction> other$transactions = other.getTransactions();
        if (this$transactions == null ? other$transactions != null : !((Object)this$transactions).equals(other$transactions)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $latestLedger = this.getLatestLedger();
        result = result * 59 + ($latestLedger == null ? 43 : ((Object)$latestLedger).hashCode());
        Long $latestLedgerCloseTimestamp = this.getLatestLedgerCloseTimestamp();
        result = result * 59 + ($latestLedgerCloseTimestamp == null ? 43 : ((Object)$latestLedgerCloseTimestamp).hashCode());
        Long $oldestLedger = this.getOldestLedger();
        result = result * 59 + ($oldestLedger == null ? 43 : ((Object)$oldestLedger).hashCode());
        Long $oldestLedgerCloseTimestamp = this.getOldestLedgerCloseTimestamp();
        result = result * 59 + ($oldestLedgerCloseTimestamp == null ? 43 : ((Object)$oldestLedgerCloseTimestamp).hashCode());
        List<Transaction> $transactions = this.getTransactions();
        result = result * 59 + ($transactions == null ? 43 : ((Object)$transactions).hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GetTransactionsResponse(transactions=" + this.getTransactions() + ", latestLedger=" + this.getLatestLedger() + ", latestLedgerCloseTimestamp=" + this.getLatestLedgerCloseTimestamp() + ", oldestLedger=" + this.getOldestLedger() + ", oldestLedgerCloseTimestamp=" + this.getOldestLedgerCloseTimestamp() + ", cursor=" + this.getCursor() + ")";
    }

    public static enum TransactionStatus {
        SUCCESS,
        FAILED;

    }

    public static final class Transaction {
        private final TransactionStatus status;
        private final Integer applicationOrder;
        private final Boolean feeBump;
        private final String envelopeXdr;
        private final String resultXdr;
        private final String resultMetaXdr;
        private final Long ledger;
        private final Long createdAt;
        private final List<String> diagnosticEventsXdr;

        public TransactionEnvelope parseEnvelopeXdr() {
            return Util.parseXdr(this.envelopeXdr, TransactionEnvelope::fromXdrBase64);
        }

        public TransactionResult parseResultXdr() {
            return Util.parseXdr(this.resultXdr, TransactionResult::fromXdrBase64);
        }

        public TransactionMeta parseResultMetaXdr() {
            return Util.parseXdr(this.resultMetaXdr, TransactionMeta::fromXdrBase64);
        }

        public List<DiagnosticEvent> parseDiagnosticEventsXdr() {
            if (this.diagnosticEventsXdr == null) {
                return null;
            }
            return this.diagnosticEventsXdr.stream().map(xdr -> Util.parseXdr(xdr, DiagnosticEvent::fromXdrBase64)).collect(Collectors.toList());
        }

        @Generated
        public Transaction(TransactionStatus status, Integer applicationOrder, Boolean feeBump, String envelopeXdr, String resultXdr, String resultMetaXdr, Long ledger, Long createdAt, List<String> diagnosticEventsXdr) {
            this.status = status;
            this.applicationOrder = applicationOrder;
            this.feeBump = feeBump;
            this.envelopeXdr = envelopeXdr;
            this.resultXdr = resultXdr;
            this.resultMetaXdr = resultMetaXdr;
            this.ledger = ledger;
            this.createdAt = createdAt;
            this.diagnosticEventsXdr = diagnosticEventsXdr;
        }

        @Generated
        public TransactionStatus getStatus() {
            return this.status;
        }

        @Generated
        public Integer getApplicationOrder() {
            return this.applicationOrder;
        }

        @Generated
        public Boolean getFeeBump() {
            return this.feeBump;
        }

        @Generated
        public String getEnvelopeXdr() {
            return this.envelopeXdr;
        }

        @Generated
        public String getResultXdr() {
            return this.resultXdr;
        }

        @Generated
        public String getResultMetaXdr() {
            return this.resultMetaXdr;
        }

        @Generated
        public Long getLedger() {
            return this.ledger;
        }

        @Generated
        public Long getCreatedAt() {
            return this.createdAt;
        }

        @Generated
        public List<String> getDiagnosticEventsXdr() {
            return this.diagnosticEventsXdr;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Transaction)) {
                return false;
            }
            Transaction other = (Transaction)o;
            Integer this$applicationOrder = this.getApplicationOrder();
            Integer other$applicationOrder = other.getApplicationOrder();
            if (this$applicationOrder == null ? other$applicationOrder != null : !((Object)this$applicationOrder).equals(other$applicationOrder)) {
                return false;
            }
            Boolean this$feeBump = this.getFeeBump();
            Boolean other$feeBump = other.getFeeBump();
            if (this$feeBump == null ? other$feeBump != null : !((Object)this$feeBump).equals(other$feeBump)) {
                return false;
            }
            Long this$ledger = this.getLedger();
            Long other$ledger = other.getLedger();
            if (this$ledger == null ? other$ledger != null : !((Object)this$ledger).equals(other$ledger)) {
                return false;
            }
            Long this$createdAt = this.getCreatedAt();
            Long other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            TransactionStatus this$status = this.getStatus();
            TransactionStatus other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            String this$envelopeXdr = this.getEnvelopeXdr();
            String other$envelopeXdr = other.getEnvelopeXdr();
            if (this$envelopeXdr == null ? other$envelopeXdr != null : !this$envelopeXdr.equals(other$envelopeXdr)) {
                return false;
            }
            String this$resultXdr = this.getResultXdr();
            String other$resultXdr = other.getResultXdr();
            if (this$resultXdr == null ? other$resultXdr != null : !this$resultXdr.equals(other$resultXdr)) {
                return false;
            }
            String this$resultMetaXdr = this.getResultMetaXdr();
            String other$resultMetaXdr = other.getResultMetaXdr();
            if (this$resultMetaXdr == null ? other$resultMetaXdr != null : !this$resultMetaXdr.equals(other$resultMetaXdr)) {
                return false;
            }
            List<String> this$diagnosticEventsXdr = this.getDiagnosticEventsXdr();
            List<String> other$diagnosticEventsXdr = other.getDiagnosticEventsXdr();
            return !(this$diagnosticEventsXdr == null ? other$diagnosticEventsXdr != null : !((Object)this$diagnosticEventsXdr).equals(other$diagnosticEventsXdr));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $applicationOrder = this.getApplicationOrder();
            result = result * 59 + ($applicationOrder == null ? 43 : ((Object)$applicationOrder).hashCode());
            Boolean $feeBump = this.getFeeBump();
            result = result * 59 + ($feeBump == null ? 43 : ((Object)$feeBump).hashCode());
            Long $ledger = this.getLedger();
            result = result * 59 + ($ledger == null ? 43 : ((Object)$ledger).hashCode());
            Long $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            TransactionStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            String $envelopeXdr = this.getEnvelopeXdr();
            result = result * 59 + ($envelopeXdr == null ? 43 : $envelopeXdr.hashCode());
            String $resultXdr = this.getResultXdr();
            result = result * 59 + ($resultXdr == null ? 43 : $resultXdr.hashCode());
            String $resultMetaXdr = this.getResultMetaXdr();
            result = result * 59 + ($resultMetaXdr == null ? 43 : $resultMetaXdr.hashCode());
            List<String> $diagnosticEventsXdr = this.getDiagnosticEventsXdr();
            result = result * 59 + ($diagnosticEventsXdr == null ? 43 : ((Object)$diagnosticEventsXdr).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GetTransactionsResponse.Transaction(status=" + (Object)((Object)this.getStatus()) + ", applicationOrder=" + this.getApplicationOrder() + ", feeBump=" + this.getFeeBump() + ", envelopeXdr=" + this.getEnvelopeXdr() + ", resultXdr=" + this.getResultXdr() + ", resultMetaXdr=" + this.getResultMetaXdr() + ", ledger=" + this.getLedger() + ", createdAt=" + this.getCreatedAt() + ", diagnosticEventsXdr=" + this.getDiagnosticEventsXdr() + ")";
        }
    }
}

