/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.sorobanrpc;

import com.google.gson.annotations.SerializedName;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.stellar.sdk.Util;
import org.stellar.sdk.xdr.DiagnosticEvent;
import org.stellar.sdk.xdr.LedgerEntry;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.SCVal;
import org.stellar.sdk.xdr.SorobanAuthorizationEntry;
import org.stellar.sdk.xdr.SorobanTransactionData;

public final class SimulateTransactionResponse {
    private final String error;
    private final String transactionData;
    private final List<String> events;
    private final Long minResourceFee;
    private final List<SimulateHostFunctionResult> results;
    private final SimulateTransactionCost cost;
    private final RestorePreamble restorePreamble;
    private final List<LedgerEntryChange> stateChanges;
    private final Long latestLedger;

    public SorobanTransactionData parseTransactionData() {
        return Util.parseXdr(this.transactionData, SorobanTransactionData::fromXdrBase64);
    }

    public List<DiagnosticEvent> parseEvents() {
        if (this.events == null) {
            return null;
        }
        return this.events.stream().map(event -> Util.parseXdr(event, DiagnosticEvent::fromXdrBase64)).collect(Collectors.toList());
    }

    @Generated
    public SimulateTransactionResponse(String error, String transactionData, List<String> events, Long minResourceFee, List<SimulateHostFunctionResult> results, SimulateTransactionCost cost, RestorePreamble restorePreamble, List<LedgerEntryChange> stateChanges, Long latestLedger) {
        this.error = error;
        this.transactionData = transactionData;
        this.events = events;
        this.minResourceFee = minResourceFee;
        this.results = results;
        this.cost = cost;
        this.restorePreamble = restorePreamble;
        this.stateChanges = stateChanges;
        this.latestLedger = latestLedger;
    }

    @Generated
    public String getError() {
        return this.error;
    }

    @Generated
    public String getTransactionData() {
        return this.transactionData;
    }

    @Generated
    public List<String> getEvents() {
        return this.events;
    }

    @Generated
    public Long getMinResourceFee() {
        return this.minResourceFee;
    }

    @Generated
    public List<SimulateHostFunctionResult> getResults() {
        return this.results;
    }

    @Generated
    public SimulateTransactionCost getCost() {
        return this.cost;
    }

    @Generated
    public RestorePreamble getRestorePreamble() {
        return this.restorePreamble;
    }

    @Generated
    public List<LedgerEntryChange> getStateChanges() {
        return this.stateChanges;
    }

    @Generated
    public Long getLatestLedger() {
        return this.latestLedger;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimulateTransactionResponse)) {
            return false;
        }
        SimulateTransactionResponse other = (SimulateTransactionResponse)o;
        Long this$minResourceFee = this.getMinResourceFee();
        Long other$minResourceFee = other.getMinResourceFee();
        if (this$minResourceFee == null ? other$minResourceFee != null : !((Object)this$minResourceFee).equals(other$minResourceFee)) {
            return false;
        }
        Long this$latestLedger = this.getLatestLedger();
        Long other$latestLedger = other.getLatestLedger();
        if (this$latestLedger == null ? other$latestLedger != null : !((Object)this$latestLedger).equals(other$latestLedger)) {
            return false;
        }
        String this$error = this.getError();
        String other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
            return false;
        }
        String this$transactionData = this.getTransactionData();
        String other$transactionData = other.getTransactionData();
        if (this$transactionData == null ? other$transactionData != null : !this$transactionData.equals(other$transactionData)) {
            return false;
        }
        List<String> this$events = this.getEvents();
        List<String> other$events = other.getEvents();
        if (this$events == null ? other$events != null : !((Object)this$events).equals(other$events)) {
            return false;
        }
        List<SimulateHostFunctionResult> this$results = this.getResults();
        List<SimulateHostFunctionResult> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        SimulateTransactionCost this$cost = this.getCost();
        SimulateTransactionCost other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        RestorePreamble this$restorePreamble = this.getRestorePreamble();
        RestorePreamble other$restorePreamble = other.getRestorePreamble();
        if (this$restorePreamble == null ? other$restorePreamble != null : !((Object)this$restorePreamble).equals(other$restorePreamble)) {
            return false;
        }
        List<LedgerEntryChange> this$stateChanges = this.getStateChanges();
        List<LedgerEntryChange> other$stateChanges = other.getStateChanges();
        return !(this$stateChanges == null ? other$stateChanges != null : !((Object)this$stateChanges).equals(other$stateChanges));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $minResourceFee = this.getMinResourceFee();
        result = result * 59 + ($minResourceFee == null ? 43 : ((Object)$minResourceFee).hashCode());
        Long $latestLedger = this.getLatestLedger();
        result = result * 59 + ($latestLedger == null ? 43 : ((Object)$latestLedger).hashCode());
        String $error = this.getError();
        result = result * 59 + ($error == null ? 43 : $error.hashCode());
        String $transactionData = this.getTransactionData();
        result = result * 59 + ($transactionData == null ? 43 : $transactionData.hashCode());
        List<String> $events = this.getEvents();
        result = result * 59 + ($events == null ? 43 : ((Object)$events).hashCode());
        List<SimulateHostFunctionResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        SimulateTransactionCost $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        RestorePreamble $restorePreamble = this.getRestorePreamble();
        result = result * 59 + ($restorePreamble == null ? 43 : ((Object)$restorePreamble).hashCode());
        List<LedgerEntryChange> $stateChanges = this.getStateChanges();
        result = result * 59 + ($stateChanges == null ? 43 : ((Object)$stateChanges).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimulateTransactionResponse(error=" + this.getError() + ", transactionData=" + this.getTransactionData() + ", events=" + this.getEvents() + ", minResourceFee=" + this.getMinResourceFee() + ", results=" + this.getResults() + ", cost=" + this.getCost() + ", restorePreamble=" + this.getRestorePreamble() + ", stateChanges=" + this.getStateChanges() + ", latestLedger=" + this.getLatestLedger() + ")";
    }

    public static final class SimulateTransactionCost {
        @SerializedName(value="cpuInsns")
        private final BigInteger cpuInstructions;
        @SerializedName(value="memBytes")
        private final BigInteger memoryBytes;

        @Generated
        public SimulateTransactionCost(BigInteger cpuInstructions, BigInteger memoryBytes) {
            this.cpuInstructions = cpuInstructions;
            this.memoryBytes = memoryBytes;
        }

        @Generated
        public BigInteger getCpuInstructions() {
            return this.cpuInstructions;
        }

        @Generated
        public BigInteger getMemoryBytes() {
            return this.memoryBytes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimulateTransactionCost)) {
                return false;
            }
            SimulateTransactionCost other = (SimulateTransactionCost)o;
            BigInteger this$cpuInstructions = this.getCpuInstructions();
            BigInteger other$cpuInstructions = other.getCpuInstructions();
            if (this$cpuInstructions == null ? other$cpuInstructions != null : !((Object)this$cpuInstructions).equals(other$cpuInstructions)) {
                return false;
            }
            BigInteger this$memoryBytes = this.getMemoryBytes();
            BigInteger other$memoryBytes = other.getMemoryBytes();
            return !(this$memoryBytes == null ? other$memoryBytes != null : !((Object)this$memoryBytes).equals(other$memoryBytes));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $cpuInstructions = this.getCpuInstructions();
            result = result * 59 + ($cpuInstructions == null ? 43 : ((Object)$cpuInstructions).hashCode());
            BigInteger $memoryBytes = this.getMemoryBytes();
            result = result * 59 + ($memoryBytes == null ? 43 : ((Object)$memoryBytes).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SimulateTransactionResponse.SimulateTransactionCost(cpuInstructions=" + this.getCpuInstructions() + ", memoryBytes=" + this.getMemoryBytes() + ")";
        }
    }

    public static final class RestorePreamble {
        private final String transactionData;
        private final Long minResourceFee;

        public SorobanTransactionData parseTransactionData() {
            return Util.parseXdr(this.transactionData, SorobanTransactionData::fromXdrBase64);
        }

        @Generated
        public RestorePreamble(String transactionData, Long minResourceFee) {
            this.transactionData = transactionData;
            this.minResourceFee = minResourceFee;
        }

        @Generated
        public String getTransactionData() {
            return this.transactionData;
        }

        @Generated
        public Long getMinResourceFee() {
            return this.minResourceFee;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RestorePreamble)) {
                return false;
            }
            RestorePreamble other = (RestorePreamble)o;
            Long this$minResourceFee = this.getMinResourceFee();
            Long other$minResourceFee = other.getMinResourceFee();
            if (this$minResourceFee == null ? other$minResourceFee != null : !((Object)this$minResourceFee).equals(other$minResourceFee)) {
                return false;
            }
            String this$transactionData = this.getTransactionData();
            String other$transactionData = other.getTransactionData();
            return !(this$transactionData == null ? other$transactionData != null : !this$transactionData.equals(other$transactionData));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $minResourceFee = this.getMinResourceFee();
            result = result * 59 + ($minResourceFee == null ? 43 : ((Object)$minResourceFee).hashCode());
            String $transactionData = this.getTransactionData();
            result = result * 59 + ($transactionData == null ? 43 : $transactionData.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SimulateTransactionResponse.RestorePreamble(transactionData=" + this.getTransactionData() + ", minResourceFee=" + this.getMinResourceFee() + ")";
        }
    }

    public static final class LedgerEntryChange {
        private final String type;
        private final String key;
        private final String before;
        private final String after;

        public LedgerKey parseKey() {
            return Util.parseXdr(this.key, LedgerKey::fromXdrBase64);
        }

        public LedgerEntry parseBefore() {
            return Util.parseXdr(this.before, LedgerEntry::fromXdrBase64);
        }

        public LedgerEntry parseAfter() {
            return Util.parseXdr(this.after, LedgerEntry::fromXdrBase64);
        }

        @Generated
        public LedgerEntryChange(String type, String key, String before, String after) {
            this.type = type;
            this.key = key;
            this.before = before;
            this.after = after;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getBefore() {
            return this.before;
        }

        @Generated
        public String getAfter() {
            return this.after;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LedgerEntryChange)) {
                return false;
            }
            LedgerEntryChange other = (LedgerEntryChange)o;
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$before = this.getBefore();
            String other$before = other.getBefore();
            if (this$before == null ? other$before != null : !this$before.equals(other$before)) {
                return false;
            }
            String this$after = this.getAfter();
            String other$after = other.getAfter();
            return !(this$after == null ? other$after != null : !this$after.equals(other$after));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $before = this.getBefore();
            result = result * 59 + ($before == null ? 43 : $before.hashCode());
            String $after = this.getAfter();
            result = result * 59 + ($after == null ? 43 : $after.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SimulateTransactionResponse.LedgerEntryChange(type=" + this.getType() + ", key=" + this.getKey() + ", before=" + this.getBefore() + ", after=" + this.getAfter() + ")";
        }
    }

    public static final class SimulateHostFunctionResult {
        private final List<String> auth;
        private final String xdr;

        public List<SorobanAuthorizationEntry> parseAuth() {
            if (this.auth == null) {
                return null;
            }
            return this.auth.stream().map(entry -> Util.parseXdr(entry, SorobanAuthorizationEntry::fromXdrBase64)).collect(Collectors.toList());
        }

        public SCVal parseXdr() {
            return Util.parseXdr(this.xdr, SCVal::fromXdrBase64);
        }

        @Generated
        public SimulateHostFunctionResult(List<String> auth, String xdr) {
            this.auth = auth;
            this.xdr = xdr;
        }

        @Generated
        public List<String> getAuth() {
            return this.auth;
        }

        @Generated
        public String getXdr() {
            return this.xdr;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimulateHostFunctionResult)) {
                return false;
            }
            SimulateHostFunctionResult other = (SimulateHostFunctionResult)o;
            List<String> this$auth = this.getAuth();
            List<String> other$auth = other.getAuth();
            if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
                return false;
            }
            String this$xdr = this.getXdr();
            String other$xdr = other.getXdr();
            return !(this$xdr == null ? other$xdr != null : !this$xdr.equals(other$xdr));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $auth = this.getAuth();
            result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
            String $xdr = this.getXdr();
            result = result * 59 + ($xdr == null ? 43 : $xdr.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SimulateTransactionResponse.SimulateHostFunctionResult(auth=" + this.getAuth() + ", xdr=" + this.getXdr() + ")";
        }
    }
}

