/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum BumpSequenceResultCode implements XdrElement
{
    BUMP_SEQUENCE_SUCCESS(0),
    BUMP_SEQUENCE_BAD_SEQ(-1);

    private final int value;

    private BumpSequenceResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BumpSequenceResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return BUMP_SEQUENCE_SUCCESS;
            }
            case -1: {
                return BUMP_SEQUENCE_BAD_SEQ;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static BumpSequenceResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return BumpSequenceResultCode.fromXdrByteArray(bytes);
    }

    public static BumpSequenceResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return BumpSequenceResultCode.decode(xdrDataInputStream);
    }
}

