/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ClaimAtomType;
import org.stellar.sdk.xdr.ClaimLiquidityAtom;
import org.stellar.sdk.xdr.ClaimOfferAtom;
import org.stellar.sdk.xdr.ClaimOfferAtomV0;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ClaimAtom
implements XdrElement {
    private ClaimAtomType discriminant;
    private ClaimOfferAtomV0 v0;
    private ClaimOfferAtom orderBook;
    private ClaimLiquidityAtom liquidityPool;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case CLAIM_ATOM_TYPE_V0: {
                this.v0.encode(stream);
                break;
            }
            case CLAIM_ATOM_TYPE_ORDER_BOOK: {
                this.orderBook.encode(stream);
                break;
            }
            case CLAIM_ATOM_TYPE_LIQUIDITY_POOL: {
                this.liquidityPool.encode(stream);
            }
        }
    }

    public static ClaimAtom decode(XdrDataInputStream stream) throws IOException {
        ClaimAtom decodedClaimAtom = new ClaimAtom();
        ClaimAtomType discriminant = ClaimAtomType.decode(stream);
        decodedClaimAtom.setDiscriminant(discriminant);
        switch (decodedClaimAtom.getDiscriminant()) {
            case CLAIM_ATOM_TYPE_V0: {
                decodedClaimAtom.v0 = ClaimOfferAtomV0.decode(stream);
                break;
            }
            case CLAIM_ATOM_TYPE_ORDER_BOOK: {
                decodedClaimAtom.orderBook = ClaimOfferAtom.decode(stream);
                break;
            }
            case CLAIM_ATOM_TYPE_LIQUIDITY_POOL: {
                decodedClaimAtom.liquidityPool = ClaimLiquidityAtom.decode(stream);
            }
        }
        return decodedClaimAtom;
    }

    public static ClaimAtom fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ClaimAtom.fromXdrByteArray(bytes);
    }

    public static ClaimAtom fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ClaimAtom.decode(xdrDataInputStream);
    }

    @Generated
    public static ClaimAtomBuilder builder() {
        return new ClaimAtomBuilder();
    }

    @Generated
    public ClaimAtomBuilder toBuilder() {
        return new ClaimAtomBuilder().discriminant(this.discriminant).v0(this.v0).orderBook(this.orderBook).liquidityPool(this.liquidityPool);
    }

    @Generated
    public ClaimAtomType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public ClaimOfferAtomV0 getV0() {
        return this.v0;
    }

    @Generated
    public ClaimOfferAtom getOrderBook() {
        return this.orderBook;
    }

    @Generated
    public ClaimLiquidityAtom getLiquidityPool() {
        return this.liquidityPool;
    }

    @Generated
    public void setDiscriminant(ClaimAtomType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setV0(ClaimOfferAtomV0 v0) {
        this.v0 = v0;
    }

    @Generated
    public void setOrderBook(ClaimOfferAtom orderBook) {
        this.orderBook = orderBook;
    }

    @Generated
    public void setLiquidityPool(ClaimLiquidityAtom liquidityPool) {
        this.liquidityPool = liquidityPool;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimAtom)) {
            return false;
        }
        ClaimAtom other = (ClaimAtom)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ClaimAtomType this$discriminant = this.getDiscriminant();
        ClaimAtomType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        ClaimOfferAtomV0 this$v0 = this.getV0();
        ClaimOfferAtomV0 other$v0 = other.getV0();
        if (this$v0 == null ? other$v0 != null : !((Object)this$v0).equals(other$v0)) {
            return false;
        }
        ClaimOfferAtom this$orderBook = this.getOrderBook();
        ClaimOfferAtom other$orderBook = other.getOrderBook();
        if (this$orderBook == null ? other$orderBook != null : !((Object)this$orderBook).equals(other$orderBook)) {
            return false;
        }
        ClaimLiquidityAtom this$liquidityPool = this.getLiquidityPool();
        ClaimLiquidityAtom other$liquidityPool = other.getLiquidityPool();
        return !(this$liquidityPool == null ? other$liquidityPool != null : !((Object)this$liquidityPool).equals(other$liquidityPool));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimAtom;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ClaimAtomType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        ClaimOfferAtomV0 $v0 = this.getV0();
        result = result * 59 + ($v0 == null ? 43 : ((Object)$v0).hashCode());
        ClaimOfferAtom $orderBook = this.getOrderBook();
        result = result * 59 + ($orderBook == null ? 43 : ((Object)$orderBook).hashCode());
        ClaimLiquidityAtom $liquidityPool = this.getLiquidityPool();
        result = result * 59 + ($liquidityPool == null ? 43 : ((Object)$liquidityPool).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClaimAtom(discriminant=" + this.getDiscriminant() + ", v0=" + this.getV0() + ", orderBook=" + this.getOrderBook() + ", liquidityPool=" + this.getLiquidityPool() + ")";
    }

    @Generated
    public ClaimAtom() {
    }

    @Generated
    public ClaimAtom(ClaimAtomType discriminant, ClaimOfferAtomV0 v0, ClaimOfferAtom orderBook, ClaimLiquidityAtom liquidityPool) {
        this.discriminant = discriminant;
        this.v0 = v0;
        this.orderBook = orderBook;
        this.liquidityPool = liquidityPool;
    }

    @Generated
    public static class ClaimAtomBuilder {
        @Generated
        private ClaimAtomType discriminant;
        @Generated
        private ClaimOfferAtomV0 v0;
        @Generated
        private ClaimOfferAtom orderBook;
        @Generated
        private ClaimLiquidityAtom liquidityPool;

        @Generated
        ClaimAtomBuilder() {
        }

        @Generated
        public ClaimAtomBuilder discriminant(ClaimAtomType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public ClaimAtomBuilder v0(ClaimOfferAtomV0 v0) {
            this.v0 = v0;
            return this;
        }

        @Generated
        public ClaimAtomBuilder orderBook(ClaimOfferAtom orderBook) {
            this.orderBook = orderBook;
            return this;
        }

        @Generated
        public ClaimAtomBuilder liquidityPool(ClaimLiquidityAtom liquidityPool) {
            this.liquidityPool = liquidityPool;
            return this;
        }

        @Generated
        public ClaimAtom build() {
            return new ClaimAtom(this.discriminant, this.v0, this.orderBook, this.liquidityPool);
        }

        @Generated
        public String toString() {
            return "ClaimAtom.ClaimAtomBuilder(discriminant=" + this.discriminant + ", v0=" + this.v0 + ", orderBook=" + this.orderBook + ", liquidityPool=" + this.liquidityPool + ")";
        }
    }
}

