/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum ContractCostType implements XdrElement
{
    WasmInsnExec(0),
    MemAlloc(1),
    MemCpy(2),
    MemCmp(3),
    DispatchHostFunction(4),
    VisitObject(5),
    ValSer(6),
    ValDeser(7),
    ComputeSha256Hash(8),
    ComputeEd25519PubKey(9),
    VerifyEd25519Sig(10),
    VmInstantiation(11),
    VmCachedInstantiation(12),
    InvokeVmFunction(13),
    ComputeKeccak256Hash(14),
    DecodeEcdsaCurve256Sig(15),
    RecoverEcdsaSecp256k1Key(16),
    Int256AddSub(17),
    Int256Mul(18),
    Int256Div(19),
    Int256Pow(20),
    Int256Shift(21),
    ChaCha20DrawBytes(22),
    ParseWasmInstructions(23),
    ParseWasmFunctions(24),
    ParseWasmGlobals(25),
    ParseWasmTableEntries(26),
    ParseWasmTypes(27),
    ParseWasmDataSegments(28),
    ParseWasmElemSegments(29),
    ParseWasmImports(30),
    ParseWasmExports(31),
    ParseWasmDataSegmentBytes(32),
    InstantiateWasmInstructions(33),
    InstantiateWasmFunctions(34),
    InstantiateWasmGlobals(35),
    InstantiateWasmTableEntries(36),
    InstantiateWasmTypes(37),
    InstantiateWasmDataSegments(38),
    InstantiateWasmElemSegments(39),
    InstantiateWasmImports(40),
    InstantiateWasmExports(41),
    InstantiateWasmDataSegmentBytes(42),
    Sec1DecodePointUncompressed(43),
    VerifyEcdsaSecp256r1Sig(44);

    private final int value;

    private ContractCostType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ContractCostType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return WasmInsnExec;
            }
            case 1: {
                return MemAlloc;
            }
            case 2: {
                return MemCpy;
            }
            case 3: {
                return MemCmp;
            }
            case 4: {
                return DispatchHostFunction;
            }
            case 5: {
                return VisitObject;
            }
            case 6: {
                return ValSer;
            }
            case 7: {
                return ValDeser;
            }
            case 8: {
                return ComputeSha256Hash;
            }
            case 9: {
                return ComputeEd25519PubKey;
            }
            case 10: {
                return VerifyEd25519Sig;
            }
            case 11: {
                return VmInstantiation;
            }
            case 12: {
                return VmCachedInstantiation;
            }
            case 13: {
                return InvokeVmFunction;
            }
            case 14: {
                return ComputeKeccak256Hash;
            }
            case 15: {
                return DecodeEcdsaCurve256Sig;
            }
            case 16: {
                return RecoverEcdsaSecp256k1Key;
            }
            case 17: {
                return Int256AddSub;
            }
            case 18: {
                return Int256Mul;
            }
            case 19: {
                return Int256Div;
            }
            case 20: {
                return Int256Pow;
            }
            case 21: {
                return Int256Shift;
            }
            case 22: {
                return ChaCha20DrawBytes;
            }
            case 23: {
                return ParseWasmInstructions;
            }
            case 24: {
                return ParseWasmFunctions;
            }
            case 25: {
                return ParseWasmGlobals;
            }
            case 26: {
                return ParseWasmTableEntries;
            }
            case 27: {
                return ParseWasmTypes;
            }
            case 28: {
                return ParseWasmDataSegments;
            }
            case 29: {
                return ParseWasmElemSegments;
            }
            case 30: {
                return ParseWasmImports;
            }
            case 31: {
                return ParseWasmExports;
            }
            case 32: {
                return ParseWasmDataSegmentBytes;
            }
            case 33: {
                return InstantiateWasmInstructions;
            }
            case 34: {
                return InstantiateWasmFunctions;
            }
            case 35: {
                return InstantiateWasmGlobals;
            }
            case 36: {
                return InstantiateWasmTableEntries;
            }
            case 37: {
                return InstantiateWasmTypes;
            }
            case 38: {
                return InstantiateWasmDataSegments;
            }
            case 39: {
                return InstantiateWasmElemSegments;
            }
            case 40: {
                return InstantiateWasmImports;
            }
            case 41: {
                return InstantiateWasmExports;
            }
            case 42: {
                return InstantiateWasmDataSegmentBytes;
            }
            case 43: {
                return Sec1DecodePointUncompressed;
            }
            case 44: {
                return VerifyEcdsaSecp256r1Sig;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static ContractCostType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractCostType.fromXdrByteArray(bytes);
    }

    public static ContractCostType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractCostType.decode(xdrDataInputStream);
    }
}

