/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ContractIDPreimageType;
import org.stellar.sdk.xdr.SCAddress;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class ContractIDPreimage
implements XdrElement {
    private ContractIDPreimageType discriminant;
    private ContractIDPreimageFromAddress fromAddress;
    private Asset fromAsset;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case CONTRACT_ID_PREIMAGE_FROM_ADDRESS: {
                this.fromAddress.encode(stream);
                break;
            }
            case CONTRACT_ID_PREIMAGE_FROM_ASSET: {
                this.fromAsset.encode(stream);
            }
        }
    }

    public static ContractIDPreimage decode(XdrDataInputStream stream) throws IOException {
        ContractIDPreimage decodedContractIDPreimage = new ContractIDPreimage();
        ContractIDPreimageType discriminant = ContractIDPreimageType.decode(stream);
        decodedContractIDPreimage.setDiscriminant(discriminant);
        switch (decodedContractIDPreimage.getDiscriminant()) {
            case CONTRACT_ID_PREIMAGE_FROM_ADDRESS: {
                decodedContractIDPreimage.fromAddress = ContractIDPreimageFromAddress.decode(stream);
                break;
            }
            case CONTRACT_ID_PREIMAGE_FROM_ASSET: {
                decodedContractIDPreimage.fromAsset = Asset.decode(stream);
            }
        }
        return decodedContractIDPreimage;
    }

    public static ContractIDPreimage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return ContractIDPreimage.fromXdrByteArray(bytes);
    }

    public static ContractIDPreimage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return ContractIDPreimage.decode(xdrDataInputStream);
    }

    @Generated
    public static ContractIDPreimageBuilder builder() {
        return new ContractIDPreimageBuilder();
    }

    @Generated
    public ContractIDPreimageBuilder toBuilder() {
        return new ContractIDPreimageBuilder().discriminant(this.discriminant).fromAddress(this.fromAddress).fromAsset(this.fromAsset);
    }

    @Generated
    public ContractIDPreimageType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public ContractIDPreimageFromAddress getFromAddress() {
        return this.fromAddress;
    }

    @Generated
    public Asset getFromAsset() {
        return this.fromAsset;
    }

    @Generated
    public void setDiscriminant(ContractIDPreimageType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setFromAddress(ContractIDPreimageFromAddress fromAddress) {
        this.fromAddress = fromAddress;
    }

    @Generated
    public void setFromAsset(Asset fromAsset) {
        this.fromAsset = fromAsset;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractIDPreimage)) {
            return false;
        }
        ContractIDPreimage other = (ContractIDPreimage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ContractIDPreimageType this$discriminant = this.getDiscriminant();
        ContractIDPreimageType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        ContractIDPreimageFromAddress this$fromAddress = this.getFromAddress();
        ContractIDPreimageFromAddress other$fromAddress = other.getFromAddress();
        if (this$fromAddress == null ? other$fromAddress != null : !((Object)this$fromAddress).equals(other$fromAddress)) {
            return false;
        }
        Asset this$fromAsset = this.getFromAsset();
        Asset other$fromAsset = other.getFromAsset();
        return !(this$fromAsset == null ? other$fromAsset != null : !((Object)this$fromAsset).equals(other$fromAsset));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContractIDPreimage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ContractIDPreimageType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        ContractIDPreimageFromAddress $fromAddress = this.getFromAddress();
        result = result * 59 + ($fromAddress == null ? 43 : ((Object)$fromAddress).hashCode());
        Asset $fromAsset = this.getFromAsset();
        result = result * 59 + ($fromAsset == null ? 43 : ((Object)$fromAsset).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContractIDPreimage(discriminant=" + this.getDiscriminant() + ", fromAddress=" + this.getFromAddress() + ", fromAsset=" + this.getFromAsset() + ")";
    }

    @Generated
    public ContractIDPreimage() {
    }

    @Generated
    public ContractIDPreimage(ContractIDPreimageType discriminant, ContractIDPreimageFromAddress fromAddress, Asset fromAsset) {
        this.discriminant = discriminant;
        this.fromAddress = fromAddress;
        this.fromAsset = fromAsset;
    }

    public static class ContractIDPreimageFromAddress
    implements XdrElement {
        private SCAddress address;
        private Uint256 salt;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            this.address.encode(stream);
            this.salt.encode(stream);
        }

        public static ContractIDPreimageFromAddress decode(XdrDataInputStream stream) throws IOException {
            ContractIDPreimageFromAddress decodedContractIDPreimageFromAddress = new ContractIDPreimageFromAddress();
            decodedContractIDPreimageFromAddress.address = SCAddress.decode(stream);
            decodedContractIDPreimageFromAddress.salt = Uint256.decode(stream);
            return decodedContractIDPreimageFromAddress;
        }

        public static ContractIDPreimageFromAddress fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return ContractIDPreimageFromAddress.fromXdrByteArray(bytes);
        }

        public static ContractIDPreimageFromAddress fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return ContractIDPreimageFromAddress.decode(xdrDataInputStream);
        }

        @Generated
        public static ContractIDPreimageFromAddressBuilder builder() {
            return new ContractIDPreimageFromAddressBuilder();
        }

        @Generated
        public ContractIDPreimageFromAddressBuilder toBuilder() {
            return new ContractIDPreimageFromAddressBuilder().address(this.address).salt(this.salt);
        }

        @Generated
        public SCAddress getAddress() {
            return this.address;
        }

        @Generated
        public Uint256 getSalt() {
            return this.salt;
        }

        @Generated
        public void setAddress(SCAddress address) {
            this.address = address;
        }

        @Generated
        public void setSalt(Uint256 salt) {
            this.salt = salt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContractIDPreimageFromAddress)) {
                return false;
            }
            ContractIDPreimageFromAddress other = (ContractIDPreimageFromAddress)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SCAddress this$address = this.getAddress();
            SCAddress other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            Uint256 this$salt = this.getSalt();
            Uint256 other$salt = other.getSalt();
            return !(this$salt == null ? other$salt != null : !((Object)this$salt).equals(other$salt));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ContractIDPreimageFromAddress;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SCAddress $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            Uint256 $salt = this.getSalt();
            result = result * 59 + ($salt == null ? 43 : ((Object)$salt).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContractIDPreimage.ContractIDPreimageFromAddress(address=" + this.getAddress() + ", salt=" + this.getSalt() + ")";
        }

        @Generated
        public ContractIDPreimageFromAddress() {
        }

        @Generated
        public ContractIDPreimageFromAddress(SCAddress address, Uint256 salt) {
            this.address = address;
            this.salt = salt;
        }

        @Generated
        public static class ContractIDPreimageFromAddressBuilder {
            @Generated
            private SCAddress address;
            @Generated
            private Uint256 salt;

            @Generated
            ContractIDPreimageFromAddressBuilder() {
            }

            @Generated
            public ContractIDPreimageFromAddressBuilder address(SCAddress address) {
                this.address = address;
                return this;
            }

            @Generated
            public ContractIDPreimageFromAddressBuilder salt(Uint256 salt) {
                this.salt = salt;
                return this;
            }

            @Generated
            public ContractIDPreimageFromAddress build() {
                return new ContractIDPreimageFromAddress(this.address, this.salt);
            }

            @Generated
            public String toString() {
                return "ContractIDPreimage.ContractIDPreimageFromAddress.ContractIDPreimageFromAddressBuilder(address=" + this.address + ", salt=" + this.salt + ")";
            }
        }
    }

    @Generated
    public static class ContractIDPreimageBuilder {
        @Generated
        private ContractIDPreimageType discriminant;
        @Generated
        private ContractIDPreimageFromAddress fromAddress;
        @Generated
        private Asset fromAsset;

        @Generated
        ContractIDPreimageBuilder() {
        }

        @Generated
        public ContractIDPreimageBuilder discriminant(ContractIDPreimageType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public ContractIDPreimageBuilder fromAddress(ContractIDPreimageFromAddress fromAddress) {
            this.fromAddress = fromAddress;
            return this;
        }

        @Generated
        public ContractIDPreimageBuilder fromAsset(Asset fromAsset) {
            this.fromAsset = fromAsset;
            return this;
        }

        @Generated
        public ContractIDPreimage build() {
            return new ContractIDPreimage(this.discriminant, this.fromAddress, this.fromAsset);
        }

        @Generated
        public String toString() {
            return "ContractIDPreimage.ContractIDPreimageBuilder(discriminant=" + this.discriminant + ", fromAddress=" + this.fromAddress + ", fromAsset=" + this.fromAsset + ")";
        }
    }
}

