/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Signature;
import org.stellar.sdk.xdr.SignatureHint;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class DecoratedSignature
implements XdrElement {
    private SignatureHint hint;
    private Signature signature;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.hint.encode(stream);
        this.signature.encode(stream);
    }

    public static DecoratedSignature decode(XdrDataInputStream stream) throws IOException {
        DecoratedSignature decodedDecoratedSignature = new DecoratedSignature();
        decodedDecoratedSignature.hint = SignatureHint.decode(stream);
        decodedDecoratedSignature.signature = Signature.decode(stream);
        return decodedDecoratedSignature;
    }

    public static DecoratedSignature fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return DecoratedSignature.fromXdrByteArray(bytes);
    }

    public static DecoratedSignature fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return DecoratedSignature.decode(xdrDataInputStream);
    }

    @Generated
    public static DecoratedSignatureBuilder builder() {
        return new DecoratedSignatureBuilder();
    }

    @Generated
    public DecoratedSignatureBuilder toBuilder() {
        return new DecoratedSignatureBuilder().hint(this.hint).signature(this.signature);
    }

    @Generated
    public SignatureHint getHint() {
        return this.hint;
    }

    @Generated
    public Signature getSignature() {
        return this.signature;
    }

    @Generated
    public void setHint(SignatureHint hint) {
        this.hint = hint;
    }

    @Generated
    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DecoratedSignature)) {
            return false;
        }
        DecoratedSignature other = (DecoratedSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SignatureHint this$hint = this.getHint();
        SignatureHint other$hint = other.getHint();
        if (this$hint == null ? other$hint != null : !((Object)this$hint).equals(other$hint)) {
            return false;
        }
        Signature this$signature = this.getSignature();
        Signature other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !((Object)this$signature).equals(other$signature));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DecoratedSignature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SignatureHint $hint = this.getHint();
        result = result * 59 + ($hint == null ? 43 : ((Object)$hint).hashCode());
        Signature $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : ((Object)$signature).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DecoratedSignature(hint=" + this.getHint() + ", signature=" + this.getSignature() + ")";
    }

    @Generated
    public DecoratedSignature() {
    }

    @Generated
    public DecoratedSignature(SignatureHint hint, Signature signature) {
        this.hint = hint;
        this.signature = signature;
    }

    @Generated
    public static class DecoratedSignatureBuilder {
        @Generated
        private SignatureHint hint;
        @Generated
        private Signature signature;

        @Generated
        DecoratedSignatureBuilder() {
        }

        @Generated
        public DecoratedSignatureBuilder hint(SignatureHint hint) {
            this.hint = hint;
            return this;
        }

        @Generated
        public DecoratedSignatureBuilder signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        @Generated
        public DecoratedSignature build() {
            return new DecoratedSignature(this.hint, this.signature);
        }

        @Generated
        public String toString() {
            return "DecoratedSignature.DecoratedSignatureBuilder(hint=" + this.hint + ", signature=" + this.signature + ")";
        }
    }
}

