/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.CreateContractArgs;
import org.stellar.sdk.xdr.HostFunctionType;
import org.stellar.sdk.xdr.InvokeContractArgs;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class HostFunction
implements XdrElement {
    private HostFunctionType discriminant;
    private InvokeContractArgs invokeContract;
    private CreateContractArgs createContract;
    private byte[] wasm;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case HOST_FUNCTION_TYPE_INVOKE_CONTRACT: {
                this.invokeContract.encode(stream);
                break;
            }
            case HOST_FUNCTION_TYPE_CREATE_CONTRACT: {
                this.createContract.encode(stream);
                break;
            }
            case HOST_FUNCTION_TYPE_UPLOAD_CONTRACT_WASM: {
                int wasmSize = this.wasm.length;
                stream.writeInt(wasmSize);
                stream.write(this.getWasm(), 0, wasmSize);
            }
        }
    }

    public static HostFunction decode(XdrDataInputStream stream) throws IOException {
        HostFunction decodedHostFunction = new HostFunction();
        HostFunctionType discriminant = HostFunctionType.decode(stream);
        decodedHostFunction.setDiscriminant(discriminant);
        switch (decodedHostFunction.getDiscriminant()) {
            case HOST_FUNCTION_TYPE_INVOKE_CONTRACT: {
                decodedHostFunction.invokeContract = InvokeContractArgs.decode(stream);
                break;
            }
            case HOST_FUNCTION_TYPE_CREATE_CONTRACT: {
                decodedHostFunction.createContract = CreateContractArgs.decode(stream);
                break;
            }
            case HOST_FUNCTION_TYPE_UPLOAD_CONTRACT_WASM: {
                int wasmSize = stream.readInt();
                decodedHostFunction.wasm = new byte[wasmSize];
                stream.read(decodedHostFunction.wasm, 0, wasmSize);
            }
        }
        return decodedHostFunction;
    }

    public static HostFunction fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HostFunction.fromXdrByteArray(bytes);
    }

    public static HostFunction fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HostFunction.decode(xdrDataInputStream);
    }

    @Generated
    public static HostFunctionBuilder builder() {
        return new HostFunctionBuilder();
    }

    @Generated
    public HostFunctionBuilder toBuilder() {
        return new HostFunctionBuilder().discriminant(this.discriminant).invokeContract(this.invokeContract).createContract(this.createContract).wasm(this.wasm);
    }

    @Generated
    public HostFunctionType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public InvokeContractArgs getInvokeContract() {
        return this.invokeContract;
    }

    @Generated
    public CreateContractArgs getCreateContract() {
        return this.createContract;
    }

    @Generated
    public byte[] getWasm() {
        return this.wasm;
    }

    @Generated
    public void setDiscriminant(HostFunctionType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setInvokeContract(InvokeContractArgs invokeContract) {
        this.invokeContract = invokeContract;
    }

    @Generated
    public void setCreateContract(CreateContractArgs createContract) {
        this.createContract = createContract;
    }

    @Generated
    public void setWasm(byte[] wasm) {
        this.wasm = wasm;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostFunction)) {
            return false;
        }
        HostFunction other = (HostFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HostFunctionType this$discriminant = this.getDiscriminant();
        HostFunctionType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        InvokeContractArgs this$invokeContract = this.getInvokeContract();
        InvokeContractArgs other$invokeContract = other.getInvokeContract();
        if (this$invokeContract == null ? other$invokeContract != null : !((Object)this$invokeContract).equals(other$invokeContract)) {
            return false;
        }
        CreateContractArgs this$createContract = this.getCreateContract();
        CreateContractArgs other$createContract = other.getCreateContract();
        if (this$createContract == null ? other$createContract != null : !((Object)this$createContract).equals(other$createContract)) {
            return false;
        }
        return Arrays.equals(this.getWasm(), other.getWasm());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HostFunction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HostFunctionType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        InvokeContractArgs $invokeContract = this.getInvokeContract();
        result = result * 59 + ($invokeContract == null ? 43 : ((Object)$invokeContract).hashCode());
        CreateContractArgs $createContract = this.getCreateContract();
        result = result * 59 + ($createContract == null ? 43 : ((Object)$createContract).hashCode());
        result = result * 59 + Arrays.hashCode(this.getWasm());
        return result;
    }

    @Generated
    public String toString() {
        return "HostFunction(discriminant=" + this.getDiscriminant() + ", invokeContract=" + this.getInvokeContract() + ", createContract=" + this.getCreateContract() + ", wasm=" + Arrays.toString(this.getWasm()) + ")";
    }

    @Generated
    public HostFunction() {
    }

    @Generated
    public HostFunction(HostFunctionType discriminant, InvokeContractArgs invokeContract, CreateContractArgs createContract, byte[] wasm) {
        this.discriminant = discriminant;
        this.invokeContract = invokeContract;
        this.createContract = createContract;
        this.wasm = wasm;
    }

    @Generated
    public static class HostFunctionBuilder {
        @Generated
        private HostFunctionType discriminant;
        @Generated
        private InvokeContractArgs invokeContract;
        @Generated
        private CreateContractArgs createContract;
        @Generated
        private byte[] wasm;

        @Generated
        HostFunctionBuilder() {
        }

        @Generated
        public HostFunctionBuilder discriminant(HostFunctionType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public HostFunctionBuilder invokeContract(InvokeContractArgs invokeContract) {
            this.invokeContract = invokeContract;
            return this;
        }

        @Generated
        public HostFunctionBuilder createContract(CreateContractArgs createContract) {
            this.createContract = createContract;
            return this;
        }

        @Generated
        public HostFunctionBuilder wasm(byte[] wasm) {
            this.wasm = wasm;
            return this;
        }

        @Generated
        public HostFunction build() {
            return new HostFunction(this.discriminant, this.invokeContract, this.createContract, this.wasm);
        }

        @Generated
        public String toString() {
            return "HostFunction.HostFunctionBuilder(discriminant=" + this.discriminant + ", invokeContract=" + this.invokeContract + ", createContract=" + this.createContract + ", wasm=" + Arrays.toString(this.wasm) + ")";
        }
    }
}

