/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum HostFunctionType implements XdrElement
{
    HOST_FUNCTION_TYPE_INVOKE_CONTRACT(0),
    HOST_FUNCTION_TYPE_CREATE_CONTRACT(1),
    HOST_FUNCTION_TYPE_UPLOAD_CONTRACT_WASM(2);

    private final int value;

    private HostFunctionType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static HostFunctionType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return HOST_FUNCTION_TYPE_INVOKE_CONTRACT;
            }
            case 1: {
                return HOST_FUNCTION_TYPE_CREATE_CONTRACT;
            }
            case 2: {
                return HOST_FUNCTION_TYPE_UPLOAD_CONTRACT_WASM;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static HostFunctionType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HostFunctionType.fromXdrByteArray(bytes);
    }

    public static HostFunctionType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HostFunctionType.decode(xdrDataInputStream);
    }
}

