/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.NodeID;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SCPQuorumSet
implements XdrElement {
    private Uint32 threshold;
    private NodeID[] validators;
    private SCPQuorumSet[] innerSets;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.threshold.encode(stream);
        int validatorsSize = this.getValidators().length;
        stream.writeInt(validatorsSize);
        for (int i = 0; i < validatorsSize; ++i) {
            this.validators[i].encode(stream);
        }
        int innerSetsSize = this.getInnerSets().length;
        stream.writeInt(innerSetsSize);
        for (int i = 0; i < innerSetsSize; ++i) {
            this.innerSets[i].encode(stream);
        }
    }

    public static SCPQuorumSet decode(XdrDataInputStream stream) throws IOException {
        SCPQuorumSet decodedSCPQuorumSet = new SCPQuorumSet();
        decodedSCPQuorumSet.threshold = Uint32.decode(stream);
        int validatorsSize = stream.readInt();
        decodedSCPQuorumSet.validators = new NodeID[validatorsSize];
        for (int i = 0; i < validatorsSize; ++i) {
            decodedSCPQuorumSet.validators[i] = NodeID.decode(stream);
        }
        int innerSetsSize = stream.readInt();
        decodedSCPQuorumSet.innerSets = new SCPQuorumSet[innerSetsSize];
        for (int i = 0; i < innerSetsSize; ++i) {
            decodedSCPQuorumSet.innerSets[i] = SCPQuorumSet.decode(stream);
        }
        return decodedSCPQuorumSet;
    }

    public static SCPQuorumSet fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCPQuorumSet.fromXdrByteArray(bytes);
    }

    public static SCPQuorumSet fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCPQuorumSet.decode(xdrDataInputStream);
    }

    @Generated
    public static SCPQuorumSetBuilder builder() {
        return new SCPQuorumSetBuilder();
    }

    @Generated
    public SCPQuorumSetBuilder toBuilder() {
        return new SCPQuorumSetBuilder().threshold(this.threshold).validators(this.validators).innerSets(this.innerSets);
    }

    @Generated
    public Uint32 getThreshold() {
        return this.threshold;
    }

    @Generated
    public NodeID[] getValidators() {
        return this.validators;
    }

    @Generated
    public SCPQuorumSet[] getInnerSets() {
        return this.innerSets;
    }

    @Generated
    public void setThreshold(Uint32 threshold) {
        this.threshold = threshold;
    }

    @Generated
    public void setValidators(NodeID[] validators) {
        this.validators = validators;
    }

    @Generated
    public void setInnerSets(SCPQuorumSet[] innerSets) {
        this.innerSets = innerSets;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SCPQuorumSet)) {
            return false;
        }
        SCPQuorumSet other = (SCPQuorumSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Uint32 this$threshold = this.getThreshold();
        Uint32 other$threshold = other.getThreshold();
        if (this$threshold == null ? other$threshold != null : !((Object)this$threshold).equals(other$threshold)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getValidators(), other.getValidators())) {
            return false;
        }
        return Arrays.deepEquals(this.getInnerSets(), other.getInnerSets());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SCPQuorumSet;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Uint32 $threshold = this.getThreshold();
        result = result * 59 + ($threshold == null ? 43 : ((Object)$threshold).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getValidators());
        result = result * 59 + Arrays.deepHashCode(this.getInnerSets());
        return result;
    }

    @Generated
    public String toString() {
        return "SCPQuorumSet(threshold=" + this.getThreshold() + ", validators=" + Arrays.deepToString(this.getValidators()) + ", innerSets=" + Arrays.deepToString(this.getInnerSets()) + ")";
    }

    @Generated
    public SCPQuorumSet() {
    }

    @Generated
    public SCPQuorumSet(Uint32 threshold, NodeID[] validators, SCPQuorumSet[] innerSets) {
        this.threshold = threshold;
        this.validators = validators;
        this.innerSets = innerSets;
    }

    @Generated
    public static class SCPQuorumSetBuilder {
        @Generated
        private Uint32 threshold;
        @Generated
        private NodeID[] validators;
        @Generated
        private SCPQuorumSet[] innerSets;

        @Generated
        SCPQuorumSetBuilder() {
        }

        @Generated
        public SCPQuorumSetBuilder threshold(Uint32 threshold) {
            this.threshold = threshold;
            return this;
        }

        @Generated
        public SCPQuorumSetBuilder validators(NodeID[] validators) {
            this.validators = validators;
            return this;
        }

        @Generated
        public SCPQuorumSetBuilder innerSets(SCPQuorumSet[] innerSets) {
            this.innerSets = innerSets;
            return this;
        }

        @Generated
        public SCPQuorumSet build() {
            return new SCPQuorumSet(this.threshold, this.validators, this.innerSets);
        }

        @Generated
        public String toString() {
            return "SCPQuorumSet.SCPQuorumSetBuilder(threshold=" + this.threshold + ", validators=" + Arrays.deepToString(this.validators) + ", innerSets=" + Arrays.deepToString(this.innerSets) + ")";
        }
    }
}

