/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.ExtensionPoint;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.SorobanResources;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class SorobanTransactionData
implements XdrElement {
    private ExtensionPoint ext;
    private SorobanResources resources;
    private Int64 resourceFee;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.ext.encode(stream);
        this.resources.encode(stream);
        this.resourceFee.encode(stream);
    }

    public static SorobanTransactionData decode(XdrDataInputStream stream) throws IOException {
        SorobanTransactionData decodedSorobanTransactionData = new SorobanTransactionData();
        decodedSorobanTransactionData.ext = ExtensionPoint.decode(stream);
        decodedSorobanTransactionData.resources = SorobanResources.decode(stream);
        decodedSorobanTransactionData.resourceFee = Int64.decode(stream);
        return decodedSorobanTransactionData;
    }

    public static SorobanTransactionData fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SorobanTransactionData.fromXdrByteArray(bytes);
    }

    public static SorobanTransactionData fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SorobanTransactionData.decode(xdrDataInputStream);
    }

    @Generated
    public static SorobanTransactionDataBuilder builder() {
        return new SorobanTransactionDataBuilder();
    }

    @Generated
    public SorobanTransactionDataBuilder toBuilder() {
        return new SorobanTransactionDataBuilder().ext(this.ext).resources(this.resources).resourceFee(this.resourceFee);
    }

    @Generated
    public ExtensionPoint getExt() {
        return this.ext;
    }

    @Generated
    public SorobanResources getResources() {
        return this.resources;
    }

    @Generated
    public Int64 getResourceFee() {
        return this.resourceFee;
    }

    @Generated
    public void setExt(ExtensionPoint ext) {
        this.ext = ext;
    }

    @Generated
    public void setResources(SorobanResources resources) {
        this.resources = resources;
    }

    @Generated
    public void setResourceFee(Int64 resourceFee) {
        this.resourceFee = resourceFee;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SorobanTransactionData)) {
            return false;
        }
        SorobanTransactionData other = (SorobanTransactionData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExtensionPoint this$ext = this.getExt();
        ExtensionPoint other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        SorobanResources this$resources = this.getResources();
        SorobanResources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Int64 this$resourceFee = this.getResourceFee();
        Int64 other$resourceFee = other.getResourceFee();
        return !(this$resourceFee == null ? other$resourceFee != null : !((Object)this$resourceFee).equals(other$resourceFee));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SorobanTransactionData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExtensionPoint $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        SorobanResources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Int64 $resourceFee = this.getResourceFee();
        result = result * 59 + ($resourceFee == null ? 43 : ((Object)$resourceFee).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SorobanTransactionData(ext=" + this.getExt() + ", resources=" + this.getResources() + ", resourceFee=" + this.getResourceFee() + ")";
    }

    @Generated
    public SorobanTransactionData() {
    }

    @Generated
    public SorobanTransactionData(ExtensionPoint ext, SorobanResources resources, Int64 resourceFee) {
        this.ext = ext;
        this.resources = resources;
        this.resourceFee = resourceFee;
    }

    @Generated
    public static class SorobanTransactionDataBuilder {
        @Generated
        private ExtensionPoint ext;
        @Generated
        private SorobanResources resources;
        @Generated
        private Int64 resourceFee;

        @Generated
        SorobanTransactionDataBuilder() {
        }

        @Generated
        public SorobanTransactionDataBuilder ext(ExtensionPoint ext) {
            this.ext = ext;
            return this;
        }

        @Generated
        public SorobanTransactionDataBuilder resources(SorobanResources resources) {
            this.resources = resources;
            return this;
        }

        @Generated
        public SorobanTransactionDataBuilder resourceFee(Int64 resourceFee) {
            this.resourceFee = resourceFee;
            return this;
        }

        @Generated
        public SorobanTransactionData build() {
            return new SorobanTransactionData(this.ext, this.resources, this.resourceFee);
        }

        @Generated
        public String toString() {
            return "SorobanTransactionData.SorobanTransactionDataBuilder(ext=" + this.ext + ", resources=" + this.resources + ", resourceFee=" + this.resourceFee + ")";
        }
    }
}

