/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Auth;
import org.stellar.sdk.xdr.DontHave;
import org.stellar.sdk.xdr.Error;
import org.stellar.sdk.xdr.FloodAdvert;
import org.stellar.sdk.xdr.FloodDemand;
import org.stellar.sdk.xdr.GeneralizedTransactionSet;
import org.stellar.sdk.xdr.Hello;
import org.stellar.sdk.xdr.MessageType;
import org.stellar.sdk.xdr.PeerAddress;
import org.stellar.sdk.xdr.SCPEnvelope;
import org.stellar.sdk.xdr.SCPQuorumSet;
import org.stellar.sdk.xdr.SendMore;
import org.stellar.sdk.xdr.SendMoreExtended;
import org.stellar.sdk.xdr.SignedSurveyRequestMessage;
import org.stellar.sdk.xdr.SignedSurveyResponseMessage;
import org.stellar.sdk.xdr.TransactionEnvelope;
import org.stellar.sdk.xdr.TransactionSet;
import org.stellar.sdk.xdr.Uint256;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class StellarMessage
implements XdrElement {
    private MessageType discriminant;
    private Error error;
    private Hello hello;
    private Auth auth;
    private DontHave dontHave;
    private PeerAddress[] peers;
    private Uint256 txSetHash;
    private TransactionSet txSet;
    private GeneralizedTransactionSet generalizedTxSet;
    private TransactionEnvelope transaction;
    private SignedSurveyRequestMessage signedSurveyRequestMessage;
    private SignedSurveyResponseMessage signedSurveyResponseMessage;
    private Uint256 qSetHash;
    private SCPQuorumSet qSet;
    private SCPEnvelope envelope;
    private Uint32 getSCPLedgerSeq;
    private SendMore sendMoreMessage;
    private SendMoreExtended sendMoreExtendedMessage;
    private FloodAdvert floodAdvert;
    private FloodDemand floodDemand;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case ERROR_MSG: {
                this.error.encode(stream);
                break;
            }
            case HELLO: {
                this.hello.encode(stream);
                break;
            }
            case AUTH: {
                this.auth.encode(stream);
                break;
            }
            case DONT_HAVE: {
                this.dontHave.encode(stream);
                break;
            }
            case GET_PEERS: {
                break;
            }
            case PEERS: {
                int peersSize = this.getPeers().length;
                stream.writeInt(peersSize);
                for (int i = 0; i < peersSize; ++i) {
                    this.peers[i].encode(stream);
                }
                break;
            }
            case GET_TX_SET: {
                this.txSetHash.encode(stream);
                break;
            }
            case TX_SET: {
                this.txSet.encode(stream);
                break;
            }
            case GENERALIZED_TX_SET: {
                this.generalizedTxSet.encode(stream);
                break;
            }
            case TRANSACTION: {
                this.transaction.encode(stream);
                break;
            }
            case SURVEY_REQUEST: {
                this.signedSurveyRequestMessage.encode(stream);
                break;
            }
            case SURVEY_RESPONSE: {
                this.signedSurveyResponseMessage.encode(stream);
                break;
            }
            case GET_SCP_QUORUMSET: {
                this.qSetHash.encode(stream);
                break;
            }
            case SCP_QUORUMSET: {
                this.qSet.encode(stream);
                break;
            }
            case SCP_MESSAGE: {
                this.envelope.encode(stream);
                break;
            }
            case GET_SCP_STATE: {
                this.getSCPLedgerSeq.encode(stream);
                break;
            }
            case SEND_MORE: {
                this.sendMoreMessage.encode(stream);
                break;
            }
            case SEND_MORE_EXTENDED: {
                this.sendMoreExtendedMessage.encode(stream);
                break;
            }
            case FLOOD_ADVERT: {
                this.floodAdvert.encode(stream);
                break;
            }
            case FLOOD_DEMAND: {
                this.floodDemand.encode(stream);
            }
        }
    }

    public static StellarMessage decode(XdrDataInputStream stream) throws IOException {
        StellarMessage decodedStellarMessage = new StellarMessage();
        MessageType discriminant = MessageType.decode(stream);
        decodedStellarMessage.setDiscriminant(discriminant);
        switch (decodedStellarMessage.getDiscriminant()) {
            case ERROR_MSG: {
                decodedStellarMessage.error = Error.decode(stream);
                break;
            }
            case HELLO: {
                decodedStellarMessage.hello = Hello.decode(stream);
                break;
            }
            case AUTH: {
                decodedStellarMessage.auth = Auth.decode(stream);
                break;
            }
            case DONT_HAVE: {
                decodedStellarMessage.dontHave = DontHave.decode(stream);
                break;
            }
            case GET_PEERS: {
                break;
            }
            case PEERS: {
                int peersSize = stream.readInt();
                decodedStellarMessage.peers = new PeerAddress[peersSize];
                for (int i = 0; i < peersSize; ++i) {
                    decodedStellarMessage.peers[i] = PeerAddress.decode(stream);
                }
                break;
            }
            case GET_TX_SET: {
                decodedStellarMessage.txSetHash = Uint256.decode(stream);
                break;
            }
            case TX_SET: {
                decodedStellarMessage.txSet = TransactionSet.decode(stream);
                break;
            }
            case GENERALIZED_TX_SET: {
                decodedStellarMessage.generalizedTxSet = GeneralizedTransactionSet.decode(stream);
                break;
            }
            case TRANSACTION: {
                decodedStellarMessage.transaction = TransactionEnvelope.decode(stream);
                break;
            }
            case SURVEY_REQUEST: {
                decodedStellarMessage.signedSurveyRequestMessage = SignedSurveyRequestMessage.decode(stream);
                break;
            }
            case SURVEY_RESPONSE: {
                decodedStellarMessage.signedSurveyResponseMessage = SignedSurveyResponseMessage.decode(stream);
                break;
            }
            case GET_SCP_QUORUMSET: {
                decodedStellarMessage.qSetHash = Uint256.decode(stream);
                break;
            }
            case SCP_QUORUMSET: {
                decodedStellarMessage.qSet = SCPQuorumSet.decode(stream);
                break;
            }
            case SCP_MESSAGE: {
                decodedStellarMessage.envelope = SCPEnvelope.decode(stream);
                break;
            }
            case GET_SCP_STATE: {
                decodedStellarMessage.getSCPLedgerSeq = Uint32.decode(stream);
                break;
            }
            case SEND_MORE: {
                decodedStellarMessage.sendMoreMessage = SendMore.decode(stream);
                break;
            }
            case SEND_MORE_EXTENDED: {
                decodedStellarMessage.sendMoreExtendedMessage = SendMoreExtended.decode(stream);
                break;
            }
            case FLOOD_ADVERT: {
                decodedStellarMessage.floodAdvert = FloodAdvert.decode(stream);
                break;
            }
            case FLOOD_DEMAND: {
                decodedStellarMessage.floodDemand = FloodDemand.decode(stream);
            }
        }
        return decodedStellarMessage;
    }

    public static StellarMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return StellarMessage.fromXdrByteArray(bytes);
    }

    public static StellarMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return StellarMessage.decode(xdrDataInputStream);
    }

    @Generated
    public static StellarMessageBuilder builder() {
        return new StellarMessageBuilder();
    }

    @Generated
    public StellarMessageBuilder toBuilder() {
        return new StellarMessageBuilder().discriminant(this.discriminant).error(this.error).hello(this.hello).auth(this.auth).dontHave(this.dontHave).peers(this.peers).txSetHash(this.txSetHash).txSet(this.txSet).generalizedTxSet(this.generalizedTxSet).transaction(this.transaction).signedSurveyRequestMessage(this.signedSurveyRequestMessage).signedSurveyResponseMessage(this.signedSurveyResponseMessage).qSetHash(this.qSetHash).qSet(this.qSet).envelope(this.envelope).getSCPLedgerSeq(this.getSCPLedgerSeq).sendMoreMessage(this.sendMoreMessage).sendMoreExtendedMessage(this.sendMoreExtendedMessage).floodAdvert(this.floodAdvert).floodDemand(this.floodDemand);
    }

    @Generated
    public MessageType getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public Error getError() {
        return this.error;
    }

    @Generated
    public Hello getHello() {
        return this.hello;
    }

    @Generated
    public Auth getAuth() {
        return this.auth;
    }

    @Generated
    public DontHave getDontHave() {
        return this.dontHave;
    }

    @Generated
    public PeerAddress[] getPeers() {
        return this.peers;
    }

    @Generated
    public Uint256 getTxSetHash() {
        return this.txSetHash;
    }

    @Generated
    public TransactionSet getTxSet() {
        return this.txSet;
    }

    @Generated
    public GeneralizedTransactionSet getGeneralizedTxSet() {
        return this.generalizedTxSet;
    }

    @Generated
    public TransactionEnvelope getTransaction() {
        return this.transaction;
    }

    @Generated
    public SignedSurveyRequestMessage getSignedSurveyRequestMessage() {
        return this.signedSurveyRequestMessage;
    }

    @Generated
    public SignedSurveyResponseMessage getSignedSurveyResponseMessage() {
        return this.signedSurveyResponseMessage;
    }

    @Generated
    public Uint256 getQSetHash() {
        return this.qSetHash;
    }

    @Generated
    public SCPQuorumSet getQSet() {
        return this.qSet;
    }

    @Generated
    public SCPEnvelope getEnvelope() {
        return this.envelope;
    }

    @Generated
    public Uint32 getGetSCPLedgerSeq() {
        return this.getSCPLedgerSeq;
    }

    @Generated
    public SendMore getSendMoreMessage() {
        return this.sendMoreMessage;
    }

    @Generated
    public SendMoreExtended getSendMoreExtendedMessage() {
        return this.sendMoreExtendedMessage;
    }

    @Generated
    public FloodAdvert getFloodAdvert() {
        return this.floodAdvert;
    }

    @Generated
    public FloodDemand getFloodDemand() {
        return this.floodDemand;
    }

    @Generated
    public void setDiscriminant(MessageType discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setError(Error error) {
        this.error = error;
    }

    @Generated
    public void setHello(Hello hello) {
        this.hello = hello;
    }

    @Generated
    public void setAuth(Auth auth) {
        this.auth = auth;
    }

    @Generated
    public void setDontHave(DontHave dontHave) {
        this.dontHave = dontHave;
    }

    @Generated
    public void setPeers(PeerAddress[] peers) {
        this.peers = peers;
    }

    @Generated
    public void setTxSetHash(Uint256 txSetHash) {
        this.txSetHash = txSetHash;
    }

    @Generated
    public void setTxSet(TransactionSet txSet) {
        this.txSet = txSet;
    }

    @Generated
    public void setGeneralizedTxSet(GeneralizedTransactionSet generalizedTxSet) {
        this.generalizedTxSet = generalizedTxSet;
    }

    @Generated
    public void setTransaction(TransactionEnvelope transaction) {
        this.transaction = transaction;
    }

    @Generated
    public void setSignedSurveyRequestMessage(SignedSurveyRequestMessage signedSurveyRequestMessage) {
        this.signedSurveyRequestMessage = signedSurveyRequestMessage;
    }

    @Generated
    public void setSignedSurveyResponseMessage(SignedSurveyResponseMessage signedSurveyResponseMessage) {
        this.signedSurveyResponseMessage = signedSurveyResponseMessage;
    }

    @Generated
    public void setQSetHash(Uint256 qSetHash) {
        this.qSetHash = qSetHash;
    }

    @Generated
    public void setQSet(SCPQuorumSet qSet) {
        this.qSet = qSet;
    }

    @Generated
    public void setEnvelope(SCPEnvelope envelope) {
        this.envelope = envelope;
    }

    @Generated
    public void setGetSCPLedgerSeq(Uint32 getSCPLedgerSeq) {
        this.getSCPLedgerSeq = getSCPLedgerSeq;
    }

    @Generated
    public void setSendMoreMessage(SendMore sendMoreMessage) {
        this.sendMoreMessage = sendMoreMessage;
    }

    @Generated
    public void setSendMoreExtendedMessage(SendMoreExtended sendMoreExtendedMessage) {
        this.sendMoreExtendedMessage = sendMoreExtendedMessage;
    }

    @Generated
    public void setFloodAdvert(FloodAdvert floodAdvert) {
        this.floodAdvert = floodAdvert;
    }

    @Generated
    public void setFloodDemand(FloodDemand floodDemand) {
        this.floodDemand = floodDemand;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StellarMessage)) {
            return false;
        }
        StellarMessage other = (StellarMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MessageType this$discriminant = this.getDiscriminant();
        MessageType other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        Error this$error = this.getError();
        Error other$error = other.getError();
        if (this$error == null ? other$error != null : !((Object)this$error).equals(other$error)) {
            return false;
        }
        Hello this$hello = this.getHello();
        Hello other$hello = other.getHello();
        if (this$hello == null ? other$hello != null : !((Object)this$hello).equals(other$hello)) {
            return false;
        }
        Auth this$auth = this.getAuth();
        Auth other$auth = other.getAuth();
        if (this$auth == null ? other$auth != null : !((Object)this$auth).equals(other$auth)) {
            return false;
        }
        DontHave this$dontHave = this.getDontHave();
        DontHave other$dontHave = other.getDontHave();
        if (this$dontHave == null ? other$dontHave != null : !((Object)this$dontHave).equals(other$dontHave)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPeers(), other.getPeers())) {
            return false;
        }
        Uint256 this$txSetHash = this.getTxSetHash();
        Uint256 other$txSetHash = other.getTxSetHash();
        if (this$txSetHash == null ? other$txSetHash != null : !((Object)this$txSetHash).equals(other$txSetHash)) {
            return false;
        }
        TransactionSet this$txSet = this.getTxSet();
        TransactionSet other$txSet = other.getTxSet();
        if (this$txSet == null ? other$txSet != null : !((Object)this$txSet).equals(other$txSet)) {
            return false;
        }
        GeneralizedTransactionSet this$generalizedTxSet = this.getGeneralizedTxSet();
        GeneralizedTransactionSet other$generalizedTxSet = other.getGeneralizedTxSet();
        if (this$generalizedTxSet == null ? other$generalizedTxSet != null : !((Object)this$generalizedTxSet).equals(other$generalizedTxSet)) {
            return false;
        }
        TransactionEnvelope this$transaction = this.getTransaction();
        TransactionEnvelope other$transaction = other.getTransaction();
        if (this$transaction == null ? other$transaction != null : !((Object)this$transaction).equals(other$transaction)) {
            return false;
        }
        SignedSurveyRequestMessage this$signedSurveyRequestMessage = this.getSignedSurveyRequestMessage();
        SignedSurveyRequestMessage other$signedSurveyRequestMessage = other.getSignedSurveyRequestMessage();
        if (this$signedSurveyRequestMessage == null ? other$signedSurveyRequestMessage != null : !((Object)this$signedSurveyRequestMessage).equals(other$signedSurveyRequestMessage)) {
            return false;
        }
        SignedSurveyResponseMessage this$signedSurveyResponseMessage = this.getSignedSurveyResponseMessage();
        SignedSurveyResponseMessage other$signedSurveyResponseMessage = other.getSignedSurveyResponseMessage();
        if (this$signedSurveyResponseMessage == null ? other$signedSurveyResponseMessage != null : !((Object)this$signedSurveyResponseMessage).equals(other$signedSurveyResponseMessage)) {
            return false;
        }
        Uint256 this$qSetHash = this.getQSetHash();
        Uint256 other$qSetHash = other.getQSetHash();
        if (this$qSetHash == null ? other$qSetHash != null : !((Object)this$qSetHash).equals(other$qSetHash)) {
            return false;
        }
        SCPQuorumSet this$qSet = this.getQSet();
        SCPQuorumSet other$qSet = other.getQSet();
        if (this$qSet == null ? other$qSet != null : !((Object)this$qSet).equals(other$qSet)) {
            return false;
        }
        SCPEnvelope this$envelope = this.getEnvelope();
        SCPEnvelope other$envelope = other.getEnvelope();
        if (this$envelope == null ? other$envelope != null : !((Object)this$envelope).equals(other$envelope)) {
            return false;
        }
        Uint32 this$getSCPLedgerSeq = this.getGetSCPLedgerSeq();
        Uint32 other$getSCPLedgerSeq = other.getGetSCPLedgerSeq();
        if (this$getSCPLedgerSeq == null ? other$getSCPLedgerSeq != null : !((Object)this$getSCPLedgerSeq).equals(other$getSCPLedgerSeq)) {
            return false;
        }
        SendMore this$sendMoreMessage = this.getSendMoreMessage();
        SendMore other$sendMoreMessage = other.getSendMoreMessage();
        if (this$sendMoreMessage == null ? other$sendMoreMessage != null : !((Object)this$sendMoreMessage).equals(other$sendMoreMessage)) {
            return false;
        }
        SendMoreExtended this$sendMoreExtendedMessage = this.getSendMoreExtendedMessage();
        SendMoreExtended other$sendMoreExtendedMessage = other.getSendMoreExtendedMessage();
        if (this$sendMoreExtendedMessage == null ? other$sendMoreExtendedMessage != null : !((Object)this$sendMoreExtendedMessage).equals(other$sendMoreExtendedMessage)) {
            return false;
        }
        FloodAdvert this$floodAdvert = this.getFloodAdvert();
        FloodAdvert other$floodAdvert = other.getFloodAdvert();
        if (this$floodAdvert == null ? other$floodAdvert != null : !((Object)this$floodAdvert).equals(other$floodAdvert)) {
            return false;
        }
        FloodDemand this$floodDemand = this.getFloodDemand();
        FloodDemand other$floodDemand = other.getFloodDemand();
        return !(this$floodDemand == null ? other$floodDemand != null : !((Object)this$floodDemand).equals(other$floodDemand));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StellarMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MessageType $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        Error $error = this.getError();
        result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
        Hello $hello = this.getHello();
        result = result * 59 + ($hello == null ? 43 : ((Object)$hello).hashCode());
        Auth $auth = this.getAuth();
        result = result * 59 + ($auth == null ? 43 : ((Object)$auth).hashCode());
        DontHave $dontHave = this.getDontHave();
        result = result * 59 + ($dontHave == null ? 43 : ((Object)$dontHave).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPeers());
        Uint256 $txSetHash = this.getTxSetHash();
        result = result * 59 + ($txSetHash == null ? 43 : ((Object)$txSetHash).hashCode());
        TransactionSet $txSet = this.getTxSet();
        result = result * 59 + ($txSet == null ? 43 : ((Object)$txSet).hashCode());
        GeneralizedTransactionSet $generalizedTxSet = this.getGeneralizedTxSet();
        result = result * 59 + ($generalizedTxSet == null ? 43 : ((Object)$generalizedTxSet).hashCode());
        TransactionEnvelope $transaction = this.getTransaction();
        result = result * 59 + ($transaction == null ? 43 : ((Object)$transaction).hashCode());
        SignedSurveyRequestMessage $signedSurveyRequestMessage = this.getSignedSurveyRequestMessage();
        result = result * 59 + ($signedSurveyRequestMessage == null ? 43 : ((Object)$signedSurveyRequestMessage).hashCode());
        SignedSurveyResponseMessage $signedSurveyResponseMessage = this.getSignedSurveyResponseMessage();
        result = result * 59 + ($signedSurveyResponseMessage == null ? 43 : ((Object)$signedSurveyResponseMessage).hashCode());
        Uint256 $qSetHash = this.getQSetHash();
        result = result * 59 + ($qSetHash == null ? 43 : ((Object)$qSetHash).hashCode());
        SCPQuorumSet $qSet = this.getQSet();
        result = result * 59 + ($qSet == null ? 43 : ((Object)$qSet).hashCode());
        SCPEnvelope $envelope = this.getEnvelope();
        result = result * 59 + ($envelope == null ? 43 : ((Object)$envelope).hashCode());
        Uint32 $getSCPLedgerSeq = this.getGetSCPLedgerSeq();
        result = result * 59 + ($getSCPLedgerSeq == null ? 43 : ((Object)$getSCPLedgerSeq).hashCode());
        SendMore $sendMoreMessage = this.getSendMoreMessage();
        result = result * 59 + ($sendMoreMessage == null ? 43 : ((Object)$sendMoreMessage).hashCode());
        SendMoreExtended $sendMoreExtendedMessage = this.getSendMoreExtendedMessage();
        result = result * 59 + ($sendMoreExtendedMessage == null ? 43 : ((Object)$sendMoreExtendedMessage).hashCode());
        FloodAdvert $floodAdvert = this.getFloodAdvert();
        result = result * 59 + ($floodAdvert == null ? 43 : ((Object)$floodAdvert).hashCode());
        FloodDemand $floodDemand = this.getFloodDemand();
        result = result * 59 + ($floodDemand == null ? 43 : ((Object)$floodDemand).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StellarMessage(discriminant=" + this.getDiscriminant() + ", error=" + this.getError() + ", hello=" + this.getHello() + ", auth=" + this.getAuth() + ", dontHave=" + this.getDontHave() + ", peers=" + Arrays.deepToString(this.getPeers()) + ", txSetHash=" + this.getTxSetHash() + ", txSet=" + this.getTxSet() + ", generalizedTxSet=" + this.getGeneralizedTxSet() + ", transaction=" + this.getTransaction() + ", signedSurveyRequestMessage=" + this.getSignedSurveyRequestMessage() + ", signedSurveyResponseMessage=" + this.getSignedSurveyResponseMessage() + ", qSetHash=" + this.getQSetHash() + ", qSet=" + this.getQSet() + ", envelope=" + this.getEnvelope() + ", getSCPLedgerSeq=" + this.getGetSCPLedgerSeq() + ", sendMoreMessage=" + this.getSendMoreMessage() + ", sendMoreExtendedMessage=" + this.getSendMoreExtendedMessage() + ", floodAdvert=" + this.getFloodAdvert() + ", floodDemand=" + this.getFloodDemand() + ")";
    }

    @Generated
    public StellarMessage() {
    }

    @Generated
    public StellarMessage(MessageType discriminant, Error error, Hello hello, Auth auth, DontHave dontHave, PeerAddress[] peers, Uint256 txSetHash, TransactionSet txSet, GeneralizedTransactionSet generalizedTxSet, TransactionEnvelope transaction, SignedSurveyRequestMessage signedSurveyRequestMessage, SignedSurveyResponseMessage signedSurveyResponseMessage, Uint256 qSetHash, SCPQuorumSet qSet, SCPEnvelope envelope, Uint32 getSCPLedgerSeq, SendMore sendMoreMessage, SendMoreExtended sendMoreExtendedMessage, FloodAdvert floodAdvert, FloodDemand floodDemand) {
        this.discriminant = discriminant;
        this.error = error;
        this.hello = hello;
        this.auth = auth;
        this.dontHave = dontHave;
        this.peers = peers;
        this.txSetHash = txSetHash;
        this.txSet = txSet;
        this.generalizedTxSet = generalizedTxSet;
        this.transaction = transaction;
        this.signedSurveyRequestMessage = signedSurveyRequestMessage;
        this.signedSurveyResponseMessage = signedSurveyResponseMessage;
        this.qSetHash = qSetHash;
        this.qSet = qSet;
        this.envelope = envelope;
        this.getSCPLedgerSeq = getSCPLedgerSeq;
        this.sendMoreMessage = sendMoreMessage;
        this.sendMoreExtendedMessage = sendMoreExtendedMessage;
        this.floodAdvert = floodAdvert;
        this.floodDemand = floodDemand;
    }

    @Generated
    public static class StellarMessageBuilder {
        @Generated
        private MessageType discriminant;
        @Generated
        private Error error;
        @Generated
        private Hello hello;
        @Generated
        private Auth auth;
        @Generated
        private DontHave dontHave;
        @Generated
        private PeerAddress[] peers;
        @Generated
        private Uint256 txSetHash;
        @Generated
        private TransactionSet txSet;
        @Generated
        private GeneralizedTransactionSet generalizedTxSet;
        @Generated
        private TransactionEnvelope transaction;
        @Generated
        private SignedSurveyRequestMessage signedSurveyRequestMessage;
        @Generated
        private SignedSurveyResponseMessage signedSurveyResponseMessage;
        @Generated
        private Uint256 qSetHash;
        @Generated
        private SCPQuorumSet qSet;
        @Generated
        private SCPEnvelope envelope;
        @Generated
        private Uint32 getSCPLedgerSeq;
        @Generated
        private SendMore sendMoreMessage;
        @Generated
        private SendMoreExtended sendMoreExtendedMessage;
        @Generated
        private FloodAdvert floodAdvert;
        @Generated
        private FloodDemand floodDemand;

        @Generated
        StellarMessageBuilder() {
        }

        @Generated
        public StellarMessageBuilder discriminant(MessageType discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public StellarMessageBuilder error(Error error) {
            this.error = error;
            return this;
        }

        @Generated
        public StellarMessageBuilder hello(Hello hello) {
            this.hello = hello;
            return this;
        }

        @Generated
        public StellarMessageBuilder auth(Auth auth) {
            this.auth = auth;
            return this;
        }

        @Generated
        public StellarMessageBuilder dontHave(DontHave dontHave) {
            this.dontHave = dontHave;
            return this;
        }

        @Generated
        public StellarMessageBuilder peers(PeerAddress[] peers) {
            this.peers = peers;
            return this;
        }

        @Generated
        public StellarMessageBuilder txSetHash(Uint256 txSetHash) {
            this.txSetHash = txSetHash;
            return this;
        }

        @Generated
        public StellarMessageBuilder txSet(TransactionSet txSet) {
            this.txSet = txSet;
            return this;
        }

        @Generated
        public StellarMessageBuilder generalizedTxSet(GeneralizedTransactionSet generalizedTxSet) {
            this.generalizedTxSet = generalizedTxSet;
            return this;
        }

        @Generated
        public StellarMessageBuilder transaction(TransactionEnvelope transaction) {
            this.transaction = transaction;
            return this;
        }

        @Generated
        public StellarMessageBuilder signedSurveyRequestMessage(SignedSurveyRequestMessage signedSurveyRequestMessage) {
            this.signedSurveyRequestMessage = signedSurveyRequestMessage;
            return this;
        }

        @Generated
        public StellarMessageBuilder signedSurveyResponseMessage(SignedSurveyResponseMessage signedSurveyResponseMessage) {
            this.signedSurveyResponseMessage = signedSurveyResponseMessage;
            return this;
        }

        @Generated
        public StellarMessageBuilder qSetHash(Uint256 qSetHash) {
            this.qSetHash = qSetHash;
            return this;
        }

        @Generated
        public StellarMessageBuilder qSet(SCPQuorumSet qSet) {
            this.qSet = qSet;
            return this;
        }

        @Generated
        public StellarMessageBuilder envelope(SCPEnvelope envelope) {
            this.envelope = envelope;
            return this;
        }

        @Generated
        public StellarMessageBuilder getSCPLedgerSeq(Uint32 getSCPLedgerSeq) {
            this.getSCPLedgerSeq = getSCPLedgerSeq;
            return this;
        }

        @Generated
        public StellarMessageBuilder sendMoreMessage(SendMore sendMoreMessage) {
            this.sendMoreMessage = sendMoreMessage;
            return this;
        }

        @Generated
        public StellarMessageBuilder sendMoreExtendedMessage(SendMoreExtended sendMoreExtendedMessage) {
            this.sendMoreExtendedMessage = sendMoreExtendedMessage;
            return this;
        }

        @Generated
        public StellarMessageBuilder floodAdvert(FloodAdvert floodAdvert) {
            this.floodAdvert = floodAdvert;
            return this;
        }

        @Generated
        public StellarMessageBuilder floodDemand(FloodDemand floodDemand) {
            this.floodDemand = floodDemand;
            return this;
        }

        @Generated
        public StellarMessage build() {
            return new StellarMessage(this.discriminant, this.error, this.hello, this.auth, this.dontHave, this.peers, this.txSetHash, this.txSet, this.generalizedTxSet, this.transaction, this.signedSurveyRequestMessage, this.signedSurveyResponseMessage, this.qSetHash, this.qSet, this.envelope, this.getSCPLedgerSeq, this.sendMoreMessage, this.sendMoreExtendedMessage, this.floodAdvert, this.floodDemand);
        }

        @Generated
        public String toString() {
            return "StellarMessage.StellarMessageBuilder(discriminant=" + this.discriminant + ", error=" + this.error + ", hello=" + this.hello + ", auth=" + this.auth + ", dontHave=" + this.dontHave + ", peers=" + Arrays.deepToString(this.peers) + ", txSetHash=" + this.txSetHash + ", txSet=" + this.txSet + ", generalizedTxSet=" + this.generalizedTxSet + ", transaction=" + this.transaction + ", signedSurveyRequestMessage=" + this.signedSurveyRequestMessage + ", signedSurveyResponseMessage=" + this.signedSurveyResponseMessage + ", qSetHash=" + this.qSetHash + ", qSet=" + this.qSet + ", envelope=" + this.envelope + ", getSCPLedgerSeq=" + this.getSCPLedgerSeq + ", sendMoreMessage=" + this.sendMoreMessage + ", sendMoreExtendedMessage=" + this.sendMoreExtendedMessage + ", floodAdvert=" + this.floodAdvert + ", floodDemand=" + this.floodDemand + ")";
        }
    }
}

