/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SurveyMessageResponseType implements XdrElement
{
    SURVEY_TOPOLOGY_RESPONSE_V0(0),
    SURVEY_TOPOLOGY_RESPONSE_V1(1);

    private final int value;

    private SurveyMessageResponseType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SurveyMessageResponseType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SURVEY_TOPOLOGY_RESPONSE_V0;
            }
            case 1: {
                return SURVEY_TOPOLOGY_RESPONSE_V1;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static SurveyMessageResponseType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SurveyMessageResponseType.fromXdrByteArray(bytes);
    }

    public static SurveyMessageResponseType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SurveyMessageResponseType.decode(xdrDataInputStream);
    }
}

