// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ClaimOfferAtomV0's original definition in the XDR file is:
 *
 * <pre>
 * struct ClaimOfferAtomV0
 * {
 *     // emitted to identify the offer
 *     uint256 sellerEd25519; // Account that owns the offer
 *     int64 offerID;
 *
 *     // amount and asset taken from the owner
 *     Asset assetSold;
 *     int64 amountSold;
 *
 *     // amount and asset sent to the owner
 *     Asset assetBought;
 *     int64 amountBought;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ClaimOfferAtomV0 implements XdrElement {
  private Uint256 sellerEd25519;
  private Int64 offerID;
  private Asset assetSold;
  private Int64 amountSold;
  private Asset assetBought;
  private Int64 amountBought;

  public void encode(XdrDataOutputStream stream) throws IOException {
    sellerEd25519.encode(stream);
    offerID.encode(stream);
    assetSold.encode(stream);
    amountSold.encode(stream);
    assetBought.encode(stream);
    amountBought.encode(stream);
  }

  public static ClaimOfferAtomV0 decode(XdrDataInputStream stream) throws IOException {
    ClaimOfferAtomV0 decodedClaimOfferAtomV0 = new ClaimOfferAtomV0();
    decodedClaimOfferAtomV0.sellerEd25519 = Uint256.decode(stream);
    decodedClaimOfferAtomV0.offerID = Int64.decode(stream);
    decodedClaimOfferAtomV0.assetSold = Asset.decode(stream);
    decodedClaimOfferAtomV0.amountSold = Int64.decode(stream);
    decodedClaimOfferAtomV0.assetBought = Asset.decode(stream);
    decodedClaimOfferAtomV0.amountBought = Int64.decode(stream);
    return decodedClaimOfferAtomV0;
  }

  public static ClaimOfferAtomV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ClaimOfferAtomV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
