// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * ClawbackResultCode's original definition in the XDR file is:
 *
 * <pre>
 * enum ClawbackResultCode
 * {
 *     // codes considered as "success" for the operation
 *     CLAWBACK_SUCCESS = 0,
 *
 *     // codes considered as "failure" for the operation
 *     CLAWBACK_MALFORMED = -1,
 *     CLAWBACK_NOT_CLAWBACK_ENABLED = -2,
 *     CLAWBACK_NO_TRUST = -3,
 *     CLAWBACK_UNDERFUNDED = -4
 * };
 * </pre>
 */
public enum ClawbackResultCode implements XdrElement {
  CLAWBACK_SUCCESS(0),
  CLAWBACK_MALFORMED(-1),
  CLAWBACK_NOT_CLAWBACK_ENABLED(-2),
  CLAWBACK_NO_TRUST(-3),
  CLAWBACK_UNDERFUNDED(-4);

  private final int value;

  ClawbackResultCode(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static ClawbackResultCode decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return CLAWBACK_SUCCESS;
      case -1:
        return CLAWBACK_MALFORMED;
      case -2:
        return CLAWBACK_NOT_CLAWBACK_ENABLED;
      case -3:
        return CLAWBACK_NO_TRUST;
      case -4:
        return CLAWBACK_UNDERFUNDED;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static ClawbackResultCode fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ClawbackResultCode fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
