// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * CreateAccountResultCode's original definition in the XDR file is:
 *
 * <pre>
 * enum CreateAccountResultCode
 * {
 *     // codes considered as "success" for the operation
 *     CREATE_ACCOUNT_SUCCESS = 0, // account was created
 *
 *     // codes considered as "failure" for the operation
 *     CREATE_ACCOUNT_MALFORMED = -1,   // invalid destination
 *     CREATE_ACCOUNT_UNDERFUNDED = -2, // not enough funds in source account
 *     CREATE_ACCOUNT_LOW_RESERVE =
 *         -3, // would create an account below the min reserve
 *     CREATE_ACCOUNT_ALREADY_EXIST = -4 // account already exists
 * };
 * </pre>
 */
public enum CreateAccountResultCode implements XdrElement {
  CREATE_ACCOUNT_SUCCESS(0),
  CREATE_ACCOUNT_MALFORMED(-1),
  CREATE_ACCOUNT_UNDERFUNDED(-2),
  CREATE_ACCOUNT_LOW_RESERVE(-3),
  CREATE_ACCOUNT_ALREADY_EXIST(-4);

  private final int value;

  CreateAccountResultCode(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static CreateAccountResultCode decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return CREATE_ACCOUNT_SUCCESS;
      case -1:
        return CREATE_ACCOUNT_MALFORMED;
      case -2:
        return CREATE_ACCOUNT_UNDERFUNDED;
      case -3:
        return CREATE_ACCOUNT_LOW_RESERVE;
      case -4:
        return CREATE_ACCOUNT_ALREADY_EXIST;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static CreateAccountResultCode fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static CreateAccountResultCode fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
