// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * DataEntry's original definition in the XDR file is:
 *
 * <pre>
 * struct DataEntry
 * {
 *     AccountID accountID; // account this data belongs to
 *     string64 dataName;
 *     DataValue dataValue;
 *
 *     // reserved for future use
 *     union switch (int v)
 *     {
 *     case 0:
 *         void;
 *     }
 *     ext;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class DataEntry implements XdrElement {
  private AccountID accountID;
  private String64 dataName;
  private DataValue dataValue;
  private DataEntryExt ext;

  public void encode(XdrDataOutputStream stream) throws IOException {
    accountID.encode(stream);
    dataName.encode(stream);
    dataValue.encode(stream);
    ext.encode(stream);
  }

  public static DataEntry decode(XdrDataInputStream stream) throws IOException {
    DataEntry decodedDataEntry = new DataEntry();
    decodedDataEntry.accountID = AccountID.decode(stream);
    decodedDataEntry.dataName = String64.decode(stream);
    decodedDataEntry.dataValue = DataValue.decode(stream);
    decodedDataEntry.ext = DataEntryExt.decode(stream);
    return decodedDataEntry;
  }

  public static DataEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static DataEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * DataEntryExt's original definition in the XDR file is:
   *
   * <pre>
   * union switch (int v)
   *     {
   *     case 0:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class DataEntryExt implements XdrElement {
    private Integer discriminant;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant);
      switch (discriminant) {
        case 0:
          break;
      }
    }

    public static DataEntryExt decode(XdrDataInputStream stream) throws IOException {
      DataEntryExt decodedDataEntryExt = new DataEntryExt();
      Integer discriminant = stream.readInt();
      decodedDataEntryExt.setDiscriminant(discriminant);
      switch (decodedDataEntryExt.getDiscriminant()) {
        case 0:
          break;
      }
      return decodedDataEntryExt;
    }

    public static DataEntryExt fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static DataEntryExt fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
