// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * InflationResult's original definition in the XDR file is:
 *
 * <pre>
 * union InflationResult switch (InflationResultCode code)
 * {
 * case INFLATION_SUCCESS:
 *     InflationPayout payouts&lt;&gt;;
 * case INFLATION_NOT_TIME:
 *     void;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class InflationResult implements XdrElement {
  private InflationResultCode discriminant;
  private InflationPayout[] payouts;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case INFLATION_SUCCESS:
        int payoutsSize = getPayouts().length;
        stream.writeInt(payoutsSize);
        for (int i = 0; i < payoutsSize; i++) {
          payouts[i].encode(stream);
        }
        break;
      case INFLATION_NOT_TIME:
        break;
    }
  }

  public static InflationResult decode(XdrDataInputStream stream) throws IOException {
    InflationResult decodedInflationResult = new InflationResult();
    InflationResultCode discriminant = InflationResultCode.decode(stream);
    decodedInflationResult.setDiscriminant(discriminant);
    switch (decodedInflationResult.getDiscriminant()) {
      case INFLATION_SUCCESS:
        int payoutsSize = stream.readInt();
        decodedInflationResult.payouts = new InflationPayout[payoutsSize];
        for (int i = 0; i < payoutsSize; i++) {
          decodedInflationResult.payouts[i] = InflationPayout.decode(stream);
        }
        break;
      case INFLATION_NOT_TIME:
        break;
    }
    return decodedInflationResult;
  }

  public static InflationResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static InflationResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
