// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * ManageOfferSuccessResult's original definition in the XDR file is:
 *
 * <pre>
 * struct ManageOfferSuccessResult
 * {
 *     // offers that got claimed while creating this offer
 *     ClaimAtom offersClaimed&lt;&gt;;
 *
 *     union switch (ManageOfferEffect effect)
 *     {
 *     case MANAGE_OFFER_CREATED:
 *     case MANAGE_OFFER_UPDATED:
 *         OfferEntry offer;
 *     case MANAGE_OFFER_DELETED:
 *         void;
 *     }
 *     offer;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class ManageOfferSuccessResult implements XdrElement {
  private ClaimAtom[] offersClaimed;
  private ManageOfferSuccessResultOffer offer;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int offersClaimedSize = getOffersClaimed().length;
    stream.writeInt(offersClaimedSize);
    for (int i = 0; i < offersClaimedSize; i++) {
      offersClaimed[i].encode(stream);
    }
    offer.encode(stream);
  }

  public static ManageOfferSuccessResult decode(XdrDataInputStream stream) throws IOException {
    ManageOfferSuccessResult decodedManageOfferSuccessResult = new ManageOfferSuccessResult();
    int offersClaimedSize = stream.readInt();
    decodedManageOfferSuccessResult.offersClaimed = new ClaimAtom[offersClaimedSize];
    for (int i = 0; i < offersClaimedSize; i++) {
      decodedManageOfferSuccessResult.offersClaimed[i] = ClaimAtom.decode(stream);
    }
    decodedManageOfferSuccessResult.offer = ManageOfferSuccessResultOffer.decode(stream);
    return decodedManageOfferSuccessResult;
  }

  public static ManageOfferSuccessResult fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static ManageOfferSuccessResult fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }

  /**
   * ManageOfferSuccessResultOffer's original definition in the XDR file is:
   *
   * <pre>
   * union switch (ManageOfferEffect effect)
   *     {
   *     case MANAGE_OFFER_CREATED:
   *     case MANAGE_OFFER_UPDATED:
   *         OfferEntry offer;
   *     case MANAGE_OFFER_DELETED:
   *         void;
   *     }
   * </pre>
   */
  @Data
  @NoArgsConstructor
  @AllArgsConstructor
  @Builder(toBuilder = true)
  public static class ManageOfferSuccessResultOffer implements XdrElement {
    private ManageOfferEffect discriminant;
    private OfferEntry offer;

    public void encode(XdrDataOutputStream stream) throws IOException {
      stream.writeInt(discriminant.getValue());
      switch (discriminant) {
        case MANAGE_OFFER_CREATED:
        case MANAGE_OFFER_UPDATED:
          offer.encode(stream);
          break;
        case MANAGE_OFFER_DELETED:
          break;
      }
    }

    public static ManageOfferSuccessResultOffer decode(XdrDataInputStream stream)
        throws IOException {
      ManageOfferSuccessResultOffer decodedManageOfferSuccessResultOffer =
          new ManageOfferSuccessResultOffer();
      ManageOfferEffect discriminant = ManageOfferEffect.decode(stream);
      decodedManageOfferSuccessResultOffer.setDiscriminant(discriminant);
      switch (decodedManageOfferSuccessResultOffer.getDiscriminant()) {
        case MANAGE_OFFER_CREATED:
        case MANAGE_OFFER_UPDATED:
          decodedManageOfferSuccessResultOffer.offer = OfferEntry.decode(stream);
          break;
        case MANAGE_OFFER_DELETED:
          break;
      }
      return decodedManageOfferSuccessResultOffer;
    }

    public static ManageOfferSuccessResultOffer fromXdrBase64(String xdr) throws IOException {
      byte[] bytes = Base64Factory.getInstance().decode(xdr);
      return fromXdrByteArray(bytes);
    }

    public static ManageOfferSuccessResultOffer fromXdrByteArray(byte[] xdr) throws IOException {
      ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
      XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
      return decode(xdrDataInputStream);
    }
  }
}
