// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * PersistedSCPStateV0's original definition in the XDR file is:
 *
 * <pre>
 * struct PersistedSCPStateV0
 * {
 * 	SCPEnvelope scpEnvelopes&lt;&gt;;
 * 	SCPQuorumSet quorumSets&lt;&gt;;
 * 	StoredTransactionSet txSets&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class PersistedSCPStateV0 implements XdrElement {
  private SCPEnvelope[] scpEnvelopes;
  private SCPQuorumSet[] quorumSets;
  private StoredTransactionSet[] txSets;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int scpEnvelopesSize = getScpEnvelopes().length;
    stream.writeInt(scpEnvelopesSize);
    for (int i = 0; i < scpEnvelopesSize; i++) {
      scpEnvelopes[i].encode(stream);
    }
    int quorumSetsSize = getQuorumSets().length;
    stream.writeInt(quorumSetsSize);
    for (int i = 0; i < quorumSetsSize; i++) {
      quorumSets[i].encode(stream);
    }
    int txSetsSize = getTxSets().length;
    stream.writeInt(txSetsSize);
    for (int i = 0; i < txSetsSize; i++) {
      txSets[i].encode(stream);
    }
  }

  public static PersistedSCPStateV0 decode(XdrDataInputStream stream) throws IOException {
    PersistedSCPStateV0 decodedPersistedSCPStateV0 = new PersistedSCPStateV0();
    int scpEnvelopesSize = stream.readInt();
    decodedPersistedSCPStateV0.scpEnvelopes = new SCPEnvelope[scpEnvelopesSize];
    for (int i = 0; i < scpEnvelopesSize; i++) {
      decodedPersistedSCPStateV0.scpEnvelopes[i] = SCPEnvelope.decode(stream);
    }
    int quorumSetsSize = stream.readInt();
    decodedPersistedSCPStateV0.quorumSets = new SCPQuorumSet[quorumSetsSize];
    for (int i = 0; i < quorumSetsSize; i++) {
      decodedPersistedSCPStateV0.quorumSets[i] = SCPQuorumSet.decode(stream);
    }
    int txSetsSize = stream.readInt();
    decodedPersistedSCPStateV0.txSets = new StoredTransactionSet[txSetsSize];
    for (int i = 0; i < txSetsSize; i++) {
      decodedPersistedSCPStateV0.txSets[i] = StoredTransactionSet.decode(stream);
    }
    return decodedPersistedSCPStateV0;
  }

  public static PersistedSCPStateV0 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static PersistedSCPStateV0 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
