// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;

/**
 * SCPStatementType's original definition in the XDR file is:
 *
 * <pre>
 * enum SCPStatementType
 * {
 *     SCP_ST_PREPARE = 0,
 *     SCP_ST_CONFIRM = 1,
 *     SCP_ST_EXTERNALIZE = 2,
 *     SCP_ST_NOMINATE = 3
 * };
 * </pre>
 */
public enum SCPStatementType implements XdrElement {
  SCP_ST_PREPARE(0),
  SCP_ST_CONFIRM(1),
  SCP_ST_EXTERNALIZE(2),
  SCP_ST_NOMINATE(3);

  private final int value;

  SCPStatementType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static SCPStatementType decode(XdrDataInputStream stream) throws IOException {
    int value = stream.readInt();
    switch (value) {
      case 0:
        return SCP_ST_PREPARE;
      case 1:
        return SCP_ST_CONFIRM;
      case 2:
        return SCP_ST_EXTERNALIZE;
      case 3:
        return SCP_ST_NOMINATE;
      default:
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }
  }

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(value);
  }

  public static SCPStatementType fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SCPStatementType fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
