// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Signature's original definition in the XDR file is:
 *
 * <pre>
 * typedef opaque Signature&lt;64&gt;;
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Signature implements XdrElement {
  private byte[] Signature;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int SignatureSize = Signature.length;
    stream.writeInt(SignatureSize);
    stream.write(getSignature(), 0, SignatureSize);
  }

  public static Signature decode(XdrDataInputStream stream) throws IOException {
    Signature decodedSignature = new Signature();
    int SignatureSize = stream.readInt();
    decodedSignature.Signature = new byte[SignatureSize];
    stream.read(decodedSignature.Signature, 0, SignatureSize);
    return decodedSignature;
  }

  public static Signature fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Signature fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
