// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * SurveyRequestMessage's original definition in the XDR file is:
 *
 * <pre>
 * struct SurveyRequestMessage
 * {
 *     NodeID surveyorPeerID;
 *     NodeID surveyedPeerID;
 *     uint32 ledgerNum;
 *     Curve25519Public encryptionKey;
 *     SurveyMessageCommandType commandType;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class SurveyRequestMessage implements XdrElement {
  private NodeID surveyorPeerID;
  private NodeID surveyedPeerID;
  private Uint32 ledgerNum;
  private Curve25519Public encryptionKey;
  private SurveyMessageCommandType commandType;

  public void encode(XdrDataOutputStream stream) throws IOException {
    surveyorPeerID.encode(stream);
    surveyedPeerID.encode(stream);
    ledgerNum.encode(stream);
    encryptionKey.encode(stream);
    commandType.encode(stream);
  }

  public static SurveyRequestMessage decode(XdrDataInputStream stream) throws IOException {
    SurveyRequestMessage decodedSurveyRequestMessage = new SurveyRequestMessage();
    decodedSurveyRequestMessage.surveyorPeerID = NodeID.decode(stream);
    decodedSurveyRequestMessage.surveyedPeerID = NodeID.decode(stream);
    decodedSurveyRequestMessage.ledgerNum = Uint32.decode(stream);
    decodedSurveyRequestMessage.encryptionKey = Curve25519Public.decode(stream);
    decodedSurveyRequestMessage.commandType = SurveyMessageCommandType.decode(stream);
    return decodedSurveyRequestMessage;
  }

  public static SurveyRequestMessage fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static SurveyRequestMessage fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
