// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * Uint256's original definition in the XDR file is:
 *
 * <pre>
 * typedef opaque uint256[32];
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class Uint256 implements XdrElement {
  private byte[] uint256;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int uint256Size = uint256.length;
    stream.write(getUint256(), 0, uint256Size);
  }

  public static Uint256 decode(XdrDataInputStream stream) throws IOException {
    Uint256 decodedUint256 = new Uint256();
    int uint256Size = 32;
    decodedUint256.uint256 = new byte[uint256Size];
    stream.read(decodedUint256.uint256, 0, uint256Size);
    return decodedUint256;
  }

  public static Uint256 fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static Uint256 fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
