/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.StrKey;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.LedgerEntryType;
import org.stellar.sdk.xdr.LedgerKey;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;
import org.stellar.sdk.xdr.RevokeSponsorshipOp;
import org.stellar.sdk.xdr.RevokeSponsorshipType;

public class RevokeAccountSponsorshipOperation
extends Operation {
    @NonNull
    private final String accountId;

    public static RevokeAccountSponsorshipOperation fromXdr(RevokeSponsorshipOp op) {
        String accountId = StrKey.encodeEd25519PublicKey(op.getLedgerKey().getAccount().getAccountID());
        return new RevokeAccountSponsorshipOperation(accountId);
    }

    @Override
    Operation.OperationBody toOperationBody() {
        RevokeSponsorshipOp op = new RevokeSponsorshipOp();
        LedgerKey key = new LedgerKey();
        key.setDiscriminant(LedgerEntryType.ACCOUNT);
        LedgerKey.LedgerKeyAccount account = new LedgerKey.LedgerKeyAccount();
        account.setAccountID(StrKey.encodeToXDRAccountId(this.accountId));
        key.setAccount(account);
        op.setLedgerKey(key);
        op.setDiscriminant(RevokeSponsorshipType.REVOKE_SPONSORSHIP_LEDGER_ENTRY);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.REVOKE_SPONSORSHIP);
        body.setRevokeSponsorshipOp(op);
        return body;
    }

    @Generated
    protected RevokeAccountSponsorshipOperation(RevokeAccountSponsorshipOperationBuilder<?, ?> b) {
        super(b);
        this.accountId = ((RevokeAccountSponsorshipOperationBuilder)b).accountId;
        if (this.accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
    }

    @Generated
    public static RevokeAccountSponsorshipOperationBuilder<?, ?> builder() {
        return new RevokeAccountSponsorshipOperationBuilderImpl();
    }

    @Generated
    public RevokeAccountSponsorshipOperationBuilder<?, ?> toBuilder() {
        return new RevokeAccountSponsorshipOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Generated
    public String toString() {
        return "RevokeAccountSponsorshipOperation(super=" + super.toString() + ", accountId=" + this.getAccountId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeAccountSponsorshipOperation)) {
            return false;
        }
        RevokeAccountSponsorshipOperation other = (RevokeAccountSponsorshipOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$accountId = this.getAccountId();
        String other$accountId = other.getAccountId();
        return !(this$accountId == null ? other$accountId != null : !this$accountId.equals(other$accountId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RevokeAccountSponsorshipOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $accountId = this.getAccountId();
        result = result * 59 + ($accountId == null ? 43 : $accountId.hashCode());
        return result;
    }

    @Generated
    private RevokeAccountSponsorshipOperation(@NonNull String accountId) {
        if (accountId == null) {
            throw new NullPointerException("accountId is marked non-null but is null");
        }
        this.accountId = accountId;
    }

    @Generated
    public static abstract class RevokeAccountSponsorshipOperationBuilder<C extends RevokeAccountSponsorshipOperation, B extends RevokeAccountSponsorshipOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String accountId;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            RevokeAccountSponsorshipOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RevokeAccountSponsorshipOperation instance, RevokeAccountSponsorshipOperationBuilder<?, ?> b) {
            b.accountId(instance.accountId);
        }

        @Generated
        public B accountId(@NonNull String accountId) {
            if (accountId == null) {
                throw new NullPointerException("accountId is marked non-null but is null");
            }
            this.accountId = accountId;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "RevokeAccountSponsorshipOperation.RevokeAccountSponsorshipOperationBuilder(super=" + super.toString() + ", accountId=" + this.accountId + ")";
        }
    }

    @Generated
    private static final class RevokeAccountSponsorshipOperationBuilderImpl
    extends RevokeAccountSponsorshipOperationBuilder<RevokeAccountSponsorshipOperation, RevokeAccountSponsorshipOperationBuilderImpl> {
        @Generated
        private RevokeAccountSponsorshipOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected RevokeAccountSponsorshipOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RevokeAccountSponsorshipOperation build() {
            return new RevokeAccountSponsorshipOperation(this);
        }
    }
}

