/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.responses.AssetResponse;
import org.stellar.sdk.responses.Page;

public class AssetsRequestBuilder
extends RequestBuilder {
    public AssetsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "assets");
    }

    public AssetsRequestBuilder assetCode(String assetCode) {
        this.uriBuilder.setQueryParameter("asset_code", assetCode);
        return this;
    }

    public AssetsRequestBuilder assetIssuer(String assetIssuer) {
        this.uriBuilder.setQueryParameter("asset_issuer", assetIssuer);
        return this;
    }

    public static Page<AssetResponse> execute(OkHttpClient httpClient, HttpUrl uri) {
        TypeToken<Page<AssetResponse>> type = new TypeToken<Page<AssetResponse>>(){};
        return AssetsRequestBuilder.executeGetRequest(httpClient, uri, type);
    }

    public Page<AssetResponse> execute() {
        return AssetsRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public AssetsRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public AssetsRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public AssetsRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

