/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.Asset;
import org.stellar.sdk.xdr.ClaimAtom;
import org.stellar.sdk.xdr.PathPaymentStrictSendResultCode;
import org.stellar.sdk.xdr.SimplePaymentResult;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class PathPaymentStrictSendResult
implements XdrElement {
    private PathPaymentStrictSendResultCode discriminant;
    private PathPaymentStrictSendResultSuccess success;
    private Asset noIssuer;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.discriminant.getValue());
        switch (this.discriminant) {
            case PATH_PAYMENT_STRICT_SEND_SUCCESS: {
                this.success.encode(stream);
                break;
            }
            case PATH_PAYMENT_STRICT_SEND_MALFORMED: 
            case PATH_PAYMENT_STRICT_SEND_UNDERFUNDED: 
            case PATH_PAYMENT_STRICT_SEND_SRC_NO_TRUST: 
            case PATH_PAYMENT_STRICT_SEND_SRC_NOT_AUTHORIZED: 
            case PATH_PAYMENT_STRICT_SEND_NO_DESTINATION: 
            case PATH_PAYMENT_STRICT_SEND_NO_TRUST: 
            case PATH_PAYMENT_STRICT_SEND_NOT_AUTHORIZED: 
            case PATH_PAYMENT_STRICT_SEND_LINE_FULL: {
                break;
            }
            case PATH_PAYMENT_STRICT_SEND_NO_ISSUER: {
                this.noIssuer.encode(stream);
                break;
            }
        }
    }

    public static PathPaymentStrictSendResult decode(XdrDataInputStream stream) throws IOException {
        PathPaymentStrictSendResult decodedPathPaymentStrictSendResult = new PathPaymentStrictSendResult();
        PathPaymentStrictSendResultCode discriminant = PathPaymentStrictSendResultCode.decode(stream);
        decodedPathPaymentStrictSendResult.setDiscriminant(discriminant);
        switch (decodedPathPaymentStrictSendResult.getDiscriminant()) {
            case PATH_PAYMENT_STRICT_SEND_SUCCESS: {
                decodedPathPaymentStrictSendResult.success = PathPaymentStrictSendResultSuccess.decode(stream);
                break;
            }
            case PATH_PAYMENT_STRICT_SEND_MALFORMED: 
            case PATH_PAYMENT_STRICT_SEND_UNDERFUNDED: 
            case PATH_PAYMENT_STRICT_SEND_SRC_NO_TRUST: 
            case PATH_PAYMENT_STRICT_SEND_SRC_NOT_AUTHORIZED: 
            case PATH_PAYMENT_STRICT_SEND_NO_DESTINATION: 
            case PATH_PAYMENT_STRICT_SEND_NO_TRUST: 
            case PATH_PAYMENT_STRICT_SEND_NOT_AUTHORIZED: 
            case PATH_PAYMENT_STRICT_SEND_LINE_FULL: {
                break;
            }
            case PATH_PAYMENT_STRICT_SEND_NO_ISSUER: {
                decodedPathPaymentStrictSendResult.noIssuer = Asset.decode(stream);
                break;
            }
        }
        return decodedPathPaymentStrictSendResult;
    }

    public static PathPaymentStrictSendResult fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return PathPaymentStrictSendResult.fromXdrByteArray(bytes);
    }

    public static PathPaymentStrictSendResult fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return PathPaymentStrictSendResult.decode(xdrDataInputStream);
    }

    @Generated
    public static PathPaymentStrictSendResultBuilder builder() {
        return new PathPaymentStrictSendResultBuilder();
    }

    @Generated
    public PathPaymentStrictSendResultBuilder toBuilder() {
        return new PathPaymentStrictSendResultBuilder().discriminant(this.discriminant).success(this.success).noIssuer(this.noIssuer);
    }

    @Generated
    public PathPaymentStrictSendResultCode getDiscriminant() {
        return this.discriminant;
    }

    @Generated
    public PathPaymentStrictSendResultSuccess getSuccess() {
        return this.success;
    }

    @Generated
    public Asset getNoIssuer() {
        return this.noIssuer;
    }

    @Generated
    public void setDiscriminant(PathPaymentStrictSendResultCode discriminant) {
        this.discriminant = discriminant;
    }

    @Generated
    public void setSuccess(PathPaymentStrictSendResultSuccess success) {
        this.success = success;
    }

    @Generated
    public void setNoIssuer(Asset noIssuer) {
        this.noIssuer = noIssuer;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathPaymentStrictSendResult)) {
            return false;
        }
        PathPaymentStrictSendResult other = (PathPaymentStrictSendResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PathPaymentStrictSendResultCode this$discriminant = this.getDiscriminant();
        PathPaymentStrictSendResultCode other$discriminant = other.getDiscriminant();
        if (this$discriminant == null ? other$discriminant != null : !this$discriminant.equals(other$discriminant)) {
            return false;
        }
        PathPaymentStrictSendResultSuccess this$success = this.getSuccess();
        PathPaymentStrictSendResultSuccess other$success = other.getSuccess();
        if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
            return false;
        }
        Asset this$noIssuer = this.getNoIssuer();
        Asset other$noIssuer = other.getNoIssuer();
        return !(this$noIssuer == null ? other$noIssuer != null : !((Object)this$noIssuer).equals(other$noIssuer));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PathPaymentStrictSendResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PathPaymentStrictSendResultCode $discriminant = this.getDiscriminant();
        result = result * 59 + ($discriminant == null ? 43 : $discriminant.hashCode());
        PathPaymentStrictSendResultSuccess $success = this.getSuccess();
        result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
        Asset $noIssuer = this.getNoIssuer();
        result = result * 59 + ($noIssuer == null ? 43 : ((Object)$noIssuer).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PathPaymentStrictSendResult(discriminant=" + this.getDiscriminant() + ", success=" + this.getSuccess() + ", noIssuer=" + this.getNoIssuer() + ")";
    }

    @Generated
    public PathPaymentStrictSendResult() {
    }

    @Generated
    public PathPaymentStrictSendResult(PathPaymentStrictSendResultCode discriminant, PathPaymentStrictSendResultSuccess success, Asset noIssuer) {
        this.discriminant = discriminant;
        this.success = success;
        this.noIssuer = noIssuer;
    }

    public static class PathPaymentStrictSendResultSuccess
    implements XdrElement {
        private ClaimAtom[] offers;
        private SimplePaymentResult last;

        @Override
        public void encode(XdrDataOutputStream stream) throws IOException {
            int offersSize = this.getOffers().length;
            stream.writeInt(offersSize);
            for (int i = 0; i < offersSize; ++i) {
                this.offers[i].encode(stream);
            }
            this.last.encode(stream);
        }

        public static PathPaymentStrictSendResultSuccess decode(XdrDataInputStream stream) throws IOException {
            PathPaymentStrictSendResultSuccess decodedPathPaymentStrictSendResultSuccess = new PathPaymentStrictSendResultSuccess();
            int offersSize = stream.readInt();
            decodedPathPaymentStrictSendResultSuccess.offers = new ClaimAtom[offersSize];
            for (int i = 0; i < offersSize; ++i) {
                decodedPathPaymentStrictSendResultSuccess.offers[i] = ClaimAtom.decode(stream);
            }
            decodedPathPaymentStrictSendResultSuccess.last = SimplePaymentResult.decode(stream);
            return decodedPathPaymentStrictSendResultSuccess;
        }

        public static PathPaymentStrictSendResultSuccess fromXdrBase64(String xdr) throws IOException {
            byte[] bytes = Base64Factory.getInstance().decode(xdr);
            return PathPaymentStrictSendResultSuccess.fromXdrByteArray(bytes);
        }

        public static PathPaymentStrictSendResultSuccess fromXdrByteArray(byte[] xdr) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
            XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
            return PathPaymentStrictSendResultSuccess.decode(xdrDataInputStream);
        }

        @Generated
        public static PathPaymentStrictSendResultSuccessBuilder builder() {
            return new PathPaymentStrictSendResultSuccessBuilder();
        }

        @Generated
        public PathPaymentStrictSendResultSuccessBuilder toBuilder() {
            return new PathPaymentStrictSendResultSuccessBuilder().offers(this.offers).last(this.last);
        }

        @Generated
        public ClaimAtom[] getOffers() {
            return this.offers;
        }

        @Generated
        public SimplePaymentResult getLast() {
            return this.last;
        }

        @Generated
        public void setOffers(ClaimAtom[] offers) {
            this.offers = offers;
        }

        @Generated
        public void setLast(SimplePaymentResult last) {
            this.last = last;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathPaymentStrictSendResultSuccess)) {
                return false;
            }
            PathPaymentStrictSendResultSuccess other = (PathPaymentStrictSendResultSuccess)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getOffers(), other.getOffers())) {
                return false;
            }
            SimplePaymentResult this$last = this.getLast();
            SimplePaymentResult other$last = other.getLast();
            return !(this$last == null ? other$last != null : !((Object)this$last).equals(other$last));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PathPaymentStrictSendResultSuccess;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.deepHashCode(this.getOffers());
            SimplePaymentResult $last = this.getLast();
            result = result * 59 + ($last == null ? 43 : ((Object)$last).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PathPaymentStrictSendResult.PathPaymentStrictSendResultSuccess(offers=" + Arrays.deepToString(this.getOffers()) + ", last=" + this.getLast() + ")";
        }

        @Generated
        public PathPaymentStrictSendResultSuccess() {
        }

        @Generated
        public PathPaymentStrictSendResultSuccess(ClaimAtom[] offers, SimplePaymentResult last) {
            this.offers = offers;
            this.last = last;
        }

        @Generated
        public static class PathPaymentStrictSendResultSuccessBuilder {
            @Generated
            private ClaimAtom[] offers;
            @Generated
            private SimplePaymentResult last;

            @Generated
            PathPaymentStrictSendResultSuccessBuilder() {
            }

            @Generated
            public PathPaymentStrictSendResultSuccessBuilder offers(ClaimAtom[] offers) {
                this.offers = offers;
                return this;
            }

            @Generated
            public PathPaymentStrictSendResultSuccessBuilder last(SimplePaymentResult last) {
                this.last = last;
                return this;
            }

            @Generated
            public PathPaymentStrictSendResultSuccess build() {
                return new PathPaymentStrictSendResultSuccess(this.offers, this.last);
            }

            @Generated
            public String toString() {
                return "PathPaymentStrictSendResult.PathPaymentStrictSendResultSuccess.PathPaymentStrictSendResultSuccessBuilder(offers=" + Arrays.deepToString(this.offers) + ", last=" + this.last + ")";
            }
        }
    }

    @Generated
    public static class PathPaymentStrictSendResultBuilder {
        @Generated
        private PathPaymentStrictSendResultCode discriminant;
        @Generated
        private PathPaymentStrictSendResultSuccess success;
        @Generated
        private Asset noIssuer;

        @Generated
        PathPaymentStrictSendResultBuilder() {
        }

        @Generated
        public PathPaymentStrictSendResultBuilder discriminant(PathPaymentStrictSendResultCode discriminant) {
            this.discriminant = discriminant;
            return this;
        }

        @Generated
        public PathPaymentStrictSendResultBuilder success(PathPaymentStrictSendResultSuccess success) {
            this.success = success;
            return this;
        }

        @Generated
        public PathPaymentStrictSendResultBuilder noIssuer(Asset noIssuer) {
            this.noIssuer = noIssuer;
            return this;
        }

        @Generated
        public PathPaymentStrictSendResult build() {
            return new PathPaymentStrictSendResult(this.discriminant, this.success, this.noIssuer);
        }

        @Generated
        public String toString() {
            return "PathPaymentStrictSendResult.PathPaymentStrictSendResultBuilder(discriminant=" + this.discriminant + ", success=" + this.success + ", noIssuer=" + this.noIssuer + ")";
        }
    }
}

