/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum SCSpecEntryKind implements XdrElement
{
    SC_SPEC_ENTRY_FUNCTION_V0(0),
    SC_SPEC_ENTRY_UDT_STRUCT_V0(1),
    SC_SPEC_ENTRY_UDT_UNION_V0(2),
    SC_SPEC_ENTRY_UDT_ENUM_V0(3),
    SC_SPEC_ENTRY_UDT_ERROR_ENUM_V0(4);

    private final int value;

    private SCSpecEntryKind(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static SCSpecEntryKind decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return SC_SPEC_ENTRY_FUNCTION_V0;
            }
            case 1: {
                return SC_SPEC_ENTRY_UDT_STRUCT_V0;
            }
            case 2: {
                return SC_SPEC_ENTRY_UDT_UNION_V0;
            }
            case 3: {
                return SC_SPEC_ENTRY_UDT_ENUM_V0;
            }
            case 4: {
                return SC_SPEC_ENTRY_UDT_ERROR_ENUM_V0;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static SCSpecEntryKind fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return SCSpecEntryKind.fromXdrByteArray(bytes);
    }

    public static SCSpecEntryKind fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return SCSpecEntryKind.decode(xdrDataInputStream);
    }
}

