/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.SurveyRequestMessage;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TimeSlicedSurveyRequestMessage
implements XdrElement {
    private SurveyRequestMessage request;
    private Uint32 nonce;
    private Uint32 inboundPeersIndex;
    private Uint32 outboundPeersIndex;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.request.encode(stream);
        this.nonce.encode(stream);
        this.inboundPeersIndex.encode(stream);
        this.outboundPeersIndex.encode(stream);
    }

    public static TimeSlicedSurveyRequestMessage decode(XdrDataInputStream stream) throws IOException {
        TimeSlicedSurveyRequestMessage decodedTimeSlicedSurveyRequestMessage = new TimeSlicedSurveyRequestMessage();
        decodedTimeSlicedSurveyRequestMessage.request = SurveyRequestMessage.decode(stream);
        decodedTimeSlicedSurveyRequestMessage.nonce = Uint32.decode(stream);
        decodedTimeSlicedSurveyRequestMessage.inboundPeersIndex = Uint32.decode(stream);
        decodedTimeSlicedSurveyRequestMessage.outboundPeersIndex = Uint32.decode(stream);
        return decodedTimeSlicedSurveyRequestMessage;
    }

    public static TimeSlicedSurveyRequestMessage fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TimeSlicedSurveyRequestMessage.fromXdrByteArray(bytes);
    }

    public static TimeSlicedSurveyRequestMessage fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TimeSlicedSurveyRequestMessage.decode(xdrDataInputStream);
    }

    @Generated
    public static TimeSlicedSurveyRequestMessageBuilder builder() {
        return new TimeSlicedSurveyRequestMessageBuilder();
    }

    @Generated
    public TimeSlicedSurveyRequestMessageBuilder toBuilder() {
        return new TimeSlicedSurveyRequestMessageBuilder().request(this.request).nonce(this.nonce).inboundPeersIndex(this.inboundPeersIndex).outboundPeersIndex(this.outboundPeersIndex);
    }

    @Generated
    public SurveyRequestMessage getRequest() {
        return this.request;
    }

    @Generated
    public Uint32 getNonce() {
        return this.nonce;
    }

    @Generated
    public Uint32 getInboundPeersIndex() {
        return this.inboundPeersIndex;
    }

    @Generated
    public Uint32 getOutboundPeersIndex() {
        return this.outboundPeersIndex;
    }

    @Generated
    public void setRequest(SurveyRequestMessage request) {
        this.request = request;
    }

    @Generated
    public void setNonce(Uint32 nonce) {
        this.nonce = nonce;
    }

    @Generated
    public void setInboundPeersIndex(Uint32 inboundPeersIndex) {
        this.inboundPeersIndex = inboundPeersIndex;
    }

    @Generated
    public void setOutboundPeersIndex(Uint32 outboundPeersIndex) {
        this.outboundPeersIndex = outboundPeersIndex;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSlicedSurveyRequestMessage)) {
            return false;
        }
        TimeSlicedSurveyRequestMessage other = (TimeSlicedSurveyRequestMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        SurveyRequestMessage this$request = this.getRequest();
        SurveyRequestMessage other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        Uint32 this$nonce = this.getNonce();
        Uint32 other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        Uint32 this$inboundPeersIndex = this.getInboundPeersIndex();
        Uint32 other$inboundPeersIndex = other.getInboundPeersIndex();
        if (this$inboundPeersIndex == null ? other$inboundPeersIndex != null : !((Object)this$inboundPeersIndex).equals(other$inboundPeersIndex)) {
            return false;
        }
        Uint32 this$outboundPeersIndex = this.getOutboundPeersIndex();
        Uint32 other$outboundPeersIndex = other.getOutboundPeersIndex();
        return !(this$outboundPeersIndex == null ? other$outboundPeersIndex != null : !((Object)this$outboundPeersIndex).equals(other$outboundPeersIndex));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimeSlicedSurveyRequestMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SurveyRequestMessage $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        Uint32 $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        Uint32 $inboundPeersIndex = this.getInboundPeersIndex();
        result = result * 59 + ($inboundPeersIndex == null ? 43 : ((Object)$inboundPeersIndex).hashCode());
        Uint32 $outboundPeersIndex = this.getOutboundPeersIndex();
        result = result * 59 + ($outboundPeersIndex == null ? 43 : ((Object)$outboundPeersIndex).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimeSlicedSurveyRequestMessage(request=" + this.getRequest() + ", nonce=" + this.getNonce() + ", inboundPeersIndex=" + this.getInboundPeersIndex() + ", outboundPeersIndex=" + this.getOutboundPeersIndex() + ")";
    }

    @Generated
    public TimeSlicedSurveyRequestMessage() {
    }

    @Generated
    public TimeSlicedSurveyRequestMessage(SurveyRequestMessage request, Uint32 nonce, Uint32 inboundPeersIndex, Uint32 outboundPeersIndex) {
        this.request = request;
        this.nonce = nonce;
        this.inboundPeersIndex = inboundPeersIndex;
        this.outboundPeersIndex = outboundPeersIndex;
    }

    @Generated
    public static class TimeSlicedSurveyRequestMessageBuilder {
        @Generated
        private SurveyRequestMessage request;
        @Generated
        private Uint32 nonce;
        @Generated
        private Uint32 inboundPeersIndex;
        @Generated
        private Uint32 outboundPeersIndex;

        @Generated
        TimeSlicedSurveyRequestMessageBuilder() {
        }

        @Generated
        public TimeSlicedSurveyRequestMessageBuilder request(SurveyRequestMessage request) {
            this.request = request;
            return this;
        }

        @Generated
        public TimeSlicedSurveyRequestMessageBuilder nonce(Uint32 nonce) {
            this.nonce = nonce;
            return this;
        }

        @Generated
        public TimeSlicedSurveyRequestMessageBuilder inboundPeersIndex(Uint32 inboundPeersIndex) {
            this.inboundPeersIndex = inboundPeersIndex;
            return this;
        }

        @Generated
        public TimeSlicedSurveyRequestMessageBuilder outboundPeersIndex(Uint32 outboundPeersIndex) {
            this.outboundPeersIndex = outboundPeersIndex;
            return this;
        }

        @Generated
        public TimeSlicedSurveyRequestMessage build() {
            return new TimeSlicedSurveyRequestMessage(this.request, this.nonce, this.inboundPeersIndex, this.outboundPeersIndex);
        }

        @Generated
        public String toString() {
            return "TimeSlicedSurveyRequestMessage.TimeSlicedSurveyRequestMessageBuilder(request=" + this.request + ", nonce=" + this.nonce + ", inboundPeersIndex=" + this.inboundPeersIndex + ", outboundPeersIndex=" + this.outboundPeersIndex + ")";
        }
    }
}

