/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;
import org.stellar.sdk.TimeBounds;
import org.stellar.sdk.xdr.Duration;
import org.stellar.sdk.xdr.Int64;
import org.stellar.sdk.xdr.LedgerBounds;
import org.stellar.sdk.xdr.PreconditionType;
import org.stellar.sdk.xdr.Preconditions;
import org.stellar.sdk.xdr.PreconditionsV2;
import org.stellar.sdk.xdr.SequenceNumber;
import org.stellar.sdk.xdr.SignerKey;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.Uint64;
import org.stellar.sdk.xdr.XdrUnsignedHyperInteger;
import org.stellar.sdk.xdr.XdrUnsignedInteger;

public final class TransactionPreconditions {
    public static final long MAX_EXTRA_SIGNERS_COUNT = 2L;
    public static final BigInteger TIMEOUT_INFINITE = BigInteger.ZERO;
    private final TimeBounds timeBounds;
    @Nullable
    private final org.stellar.sdk.LedgerBounds ledgerBounds;
    @Nullable
    private final Long minSeqNumber;
    @NonNull
    private final BigInteger minSeqAge;
    private final long minSeqLedgerGap;
    @NonNull
    private final List<SignerKey> extraSigners;

    public void isValid() {
        if (this.timeBounds == null) {
            throw new IllegalArgumentException("Invalid preconditions, must define timebounds");
        }
        if ((long)this.extraSigners.size() > 2L) {
            throw new IllegalArgumentException("Invalid preconditions, too many extra signers, can only have up to 2");
        }
    }

    public boolean hasV2() {
        return this.ledgerBounds != null || this.minSeqLedgerGap > 0L || this.minSeqAge.compareTo(BigInteger.ZERO) > 0 || this.minSeqNumber != null || !this.extraSigners.isEmpty();
    }

    public static TransactionPreconditions fromXdr(Preconditions preconditions) {
        TransactionPreconditionsBuilder builder = new TransactionPreconditionsBuilder();
        if (preconditions.getDiscriminant().equals(PreconditionType.PRECOND_V2)) {
            if (preconditions.getV2().getTimeBounds() != null) {
                builder.timeBounds(new TimeBounds(preconditions.getV2().getTimeBounds().getMinTime().getTimePoint().getUint64().getNumber(), preconditions.getV2().getTimeBounds().getMaxTime().getTimePoint().getUint64().getNumber()));
            }
            if (preconditions.getV2().getExtraSigners() != null && preconditions.getV2().getExtraSigners().length > 0) {
                builder.extraSigners(Arrays.asList(preconditions.getV2().getExtraSigners()));
            }
            if (preconditions.getV2().getMinSeqAge() != null) {
                builder.minSeqAge(preconditions.getV2().getMinSeqAge().getDuration().getUint64().getNumber());
            }
            if (preconditions.getV2().getLedgerBounds() != null) {
                builder.ledgerBounds(org.stellar.sdk.LedgerBounds.fromXdr(preconditions.getV2().getLedgerBounds()));
            }
            if (preconditions.getV2().getMinSeqNum() != null) {
                builder.minSeqNumber(preconditions.getV2().getMinSeqNum().getSequenceNumber().getInt64());
            }
            if (preconditions.getV2().getMinSeqLedgerGap() != null) {
                builder.minSeqLedgerGap(preconditions.getV2().getMinSeqLedgerGap().getUint32().getNumber().intValue());
            }
        } else if (preconditions.getTimeBounds() != null) {
            builder.timeBounds(new TimeBounds(preconditions.getTimeBounds().getMinTime().getTimePoint().getUint64().getNumber(), preconditions.getTimeBounds().getMaxTime().getTimePoint().getUint64().getNumber()));
        }
        return builder.build();
    }

    public Preconditions toXdr() {
        Preconditions.PreconditionsBuilder preconditionsBuilder = Preconditions.builder();
        if (this.hasV2()) {
            preconditionsBuilder.discriminant(PreconditionType.PRECOND_V2);
            PreconditionsV2.PreconditionsV2Builder v2Builder = PreconditionsV2.builder();
            v2Builder.extraSigners(this.extraSigners.toArray(new SignerKey[0]));
            v2Builder.minSeqAge(new Duration(new Uint64(new XdrUnsignedHyperInteger(this.minSeqAge))));
            if (this.ledgerBounds != null) {
                v2Builder.ledgerBounds(LedgerBounds.builder().minLedger(new Uint32(new XdrUnsignedInteger(this.ledgerBounds.getMinLedger()))).maxLedger(new Uint32(new XdrUnsignedInteger(this.ledgerBounds.getMaxLedger()))).build());
            }
            if (this.minSeqNumber != null) {
                v2Builder.minSeqNum(new SequenceNumber(new Int64(this.minSeqNumber)));
            }
            v2Builder.minSeqLedgerGap(new Uint32(new XdrUnsignedInteger(this.minSeqLedgerGap)));
            if (this.timeBounds != null) {
                v2Builder.timeBounds(this.timeBounds.toXdr());
            }
            preconditionsBuilder.v2(v2Builder.build());
        } else if (this.timeBounds == null) {
            preconditionsBuilder.discriminant(PreconditionType.PRECOND_NONE);
        } else {
            preconditionsBuilder.discriminant(PreconditionType.PRECOND_TIME);
            preconditionsBuilder.timeBounds(this.timeBounds.toXdr());
        }
        return preconditionsBuilder.build();
    }

    @Generated
    private static BigInteger $default$minSeqAge() {
        return BigInteger.ZERO;
    }

    @Generated
    private static List<SignerKey> $default$extraSigners() {
        return new ArrayList<SignerKey>();
    }

    @Generated
    TransactionPreconditions(TimeBounds timeBounds, @Nullable org.stellar.sdk.LedgerBounds ledgerBounds, @Nullable Long minSeqNumber, @NonNull BigInteger minSeqAge, long minSeqLedgerGap, @NonNull List<SignerKey> extraSigners) {
        if (minSeqAge == null) {
            throw new NullPointerException("minSeqAge is marked non-null but is null");
        }
        if (extraSigners == null) {
            throw new NullPointerException("extraSigners is marked non-null but is null");
        }
        this.timeBounds = timeBounds;
        this.ledgerBounds = ledgerBounds;
        this.minSeqNumber = minSeqNumber;
        this.minSeqAge = minSeqAge;
        this.minSeqLedgerGap = minSeqLedgerGap;
        this.extraSigners = extraSigners;
    }

    @Generated
    public static TransactionPreconditionsBuilder builder() {
        return new TransactionPreconditionsBuilder();
    }

    @Generated
    public TransactionPreconditionsBuilder toBuilder() {
        return new TransactionPreconditionsBuilder().timeBounds(this.timeBounds).ledgerBounds(this.ledgerBounds).minSeqNumber(this.minSeqNumber).minSeqAge(this.minSeqAge).minSeqLedgerGap(this.minSeqLedgerGap).extraSigners(this.extraSigners);
    }

    @Generated
    public TimeBounds getTimeBounds() {
        return this.timeBounds;
    }

    @Nullable
    @Generated
    public org.stellar.sdk.LedgerBounds getLedgerBounds() {
        return this.ledgerBounds;
    }

    @Nullable
    @Generated
    public Long getMinSeqNumber() {
        return this.minSeqNumber;
    }

    @NonNull
    @Generated
    public BigInteger getMinSeqAge() {
        return this.minSeqAge;
    }

    @Generated
    public long getMinSeqLedgerGap() {
        return this.minSeqLedgerGap;
    }

    @NonNull
    @Generated
    public List<SignerKey> getExtraSigners() {
        return this.extraSigners;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionPreconditions)) {
            return false;
        }
        TransactionPreconditions other = (TransactionPreconditions)o;
        if (this.getMinSeqLedgerGap() != other.getMinSeqLedgerGap()) {
            return false;
        }
        Long this$minSeqNumber = this.getMinSeqNumber();
        Long other$minSeqNumber = other.getMinSeqNumber();
        if (this$minSeqNumber == null ? other$minSeqNumber != null : !((Object)this$minSeqNumber).equals(other$minSeqNumber)) {
            return false;
        }
        TimeBounds this$timeBounds = this.getTimeBounds();
        TimeBounds other$timeBounds = other.getTimeBounds();
        if (this$timeBounds == null ? other$timeBounds != null : !((Object)this$timeBounds).equals(other$timeBounds)) {
            return false;
        }
        org.stellar.sdk.LedgerBounds this$ledgerBounds = this.getLedgerBounds();
        org.stellar.sdk.LedgerBounds other$ledgerBounds = other.getLedgerBounds();
        if (this$ledgerBounds == null ? other$ledgerBounds != null : !((Object)this$ledgerBounds).equals(other$ledgerBounds)) {
            return false;
        }
        BigInteger this$minSeqAge = this.getMinSeqAge();
        BigInteger other$minSeqAge = other.getMinSeqAge();
        if (this$minSeqAge == null ? other$minSeqAge != null : !((Object)this$minSeqAge).equals(other$minSeqAge)) {
            return false;
        }
        List<SignerKey> this$extraSigners = this.getExtraSigners();
        List<SignerKey> other$extraSigners = other.getExtraSigners();
        return !(this$extraSigners == null ? other$extraSigners != null : !((Object)this$extraSigners).equals(other$extraSigners));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $minSeqLedgerGap = this.getMinSeqLedgerGap();
        result = result * 59 + (int)($minSeqLedgerGap >>> 32 ^ $minSeqLedgerGap);
        Long $minSeqNumber = this.getMinSeqNumber();
        result = result * 59 + ($minSeqNumber == null ? 43 : ((Object)$minSeqNumber).hashCode());
        TimeBounds $timeBounds = this.getTimeBounds();
        result = result * 59 + ($timeBounds == null ? 43 : ((Object)$timeBounds).hashCode());
        org.stellar.sdk.LedgerBounds $ledgerBounds = this.getLedgerBounds();
        result = result * 59 + ($ledgerBounds == null ? 43 : ((Object)$ledgerBounds).hashCode());
        BigInteger $minSeqAge = this.getMinSeqAge();
        result = result * 59 + ($minSeqAge == null ? 43 : ((Object)$minSeqAge).hashCode());
        List<SignerKey> $extraSigners = this.getExtraSigners();
        result = result * 59 + ($extraSigners == null ? 43 : ((Object)$extraSigners).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionPreconditions(timeBounds=" + this.getTimeBounds() + ", ledgerBounds=" + this.getLedgerBounds() + ", minSeqNumber=" + this.getMinSeqNumber() + ", minSeqAge=" + this.getMinSeqAge() + ", minSeqLedgerGap=" + this.getMinSeqLedgerGap() + ", extraSigners=" + this.getExtraSigners() + ")";
    }

    @Generated
    public static class TransactionPreconditionsBuilder {
        @Generated
        private TimeBounds timeBounds;
        @Generated
        private org.stellar.sdk.LedgerBounds ledgerBounds;
        @Generated
        private Long minSeqNumber;
        @Generated
        private boolean minSeqAge$set;
        @Generated
        private BigInteger minSeqAge$value;
        @Generated
        private long minSeqLedgerGap;
        @Generated
        private boolean extraSigners$set;
        @Generated
        private List<SignerKey> extraSigners$value;

        @Generated
        TransactionPreconditionsBuilder() {
        }

        @Generated
        public TransactionPreconditionsBuilder timeBounds(TimeBounds timeBounds) {
            this.timeBounds = timeBounds;
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder ledgerBounds(@Nullable org.stellar.sdk.LedgerBounds ledgerBounds) {
            this.ledgerBounds = ledgerBounds;
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder minSeqNumber(@Nullable Long minSeqNumber) {
            this.minSeqNumber = minSeqNumber;
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder minSeqAge(@NonNull BigInteger minSeqAge) {
            if (minSeqAge == null) {
                throw new NullPointerException("minSeqAge is marked non-null but is null");
            }
            this.minSeqAge$value = minSeqAge;
            this.minSeqAge$set = true;
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder minSeqLedgerGap(long minSeqLedgerGap) {
            this.minSeqLedgerGap = minSeqLedgerGap;
            return this;
        }

        @Generated
        public TransactionPreconditionsBuilder extraSigners(@NonNull List<SignerKey> extraSigners) {
            if (extraSigners == null) {
                throw new NullPointerException("extraSigners is marked non-null but is null");
            }
            this.extraSigners$value = extraSigners;
            this.extraSigners$set = true;
            return this;
        }

        @Generated
        public TransactionPreconditions build() {
            BigInteger minSeqAge$value = this.minSeqAge$value;
            if (!this.minSeqAge$set) {
                minSeqAge$value = TransactionPreconditions.$default$minSeqAge();
            }
            List extraSigners$value = this.extraSigners$value;
            if (!this.extraSigners$set) {
                extraSigners$value = TransactionPreconditions.$default$extraSigners();
            }
            return new TransactionPreconditions(this.timeBounds, this.ledgerBounds, this.minSeqNumber, minSeqAge$value, this.minSeqLedgerGap, extraSigners$value);
        }

        @Generated
        public String toString() {
            return "TransactionPreconditions.TransactionPreconditionsBuilder(timeBounds=" + this.timeBounds + ", ledgerBounds=" + this.ledgerBounds + ", minSeqNumber=" + this.minSeqNumber + ", minSeqAge$value=" + this.minSeqAge$value + ", minSeqLedgerGap=" + this.minSeqLedgerGap + ", extraSigners$value=" + this.extraSigners$value + ")";
        }
    }
}

