/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.operations;

import java.io.IOException;
import lombok.Generated;
import lombok.NonNull;
import org.stellar.sdk.Util;
import org.stellar.sdk.operations.Operation;
import org.stellar.sdk.xdr.ClaimableBalanceID;
import org.stellar.sdk.xdr.ClawbackClaimableBalanceOp;
import org.stellar.sdk.xdr.Operation;
import org.stellar.sdk.xdr.OperationType;

public class ClawbackClaimableBalanceOperation
extends Operation {
    @NonNull
    private final String balanceId;

    public static ClawbackClaimableBalanceOperation fromXdr(ClawbackClaimableBalanceOp op) {
        try {
            String balanceId = Util.bytesToHex(op.getBalanceID().toXdrByteArray()).toLowerCase();
            return new ClawbackClaimableBalanceOperation(balanceId);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid balanceId in the operation", e);
        }
    }

    @Override
    Operation.OperationBody toOperationBody() {
        ClaimableBalanceID balanceId;
        byte[] balanceIdBytes = Util.hexToBytes(this.balanceId);
        try {
            balanceId = ClaimableBalanceID.fromXdrByteArray(balanceIdBytes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid balanceId: " + this.balanceId, e);
        }
        ClawbackClaimableBalanceOp op = new ClawbackClaimableBalanceOp();
        op.setBalanceID(balanceId);
        Operation.OperationBody body = new Operation.OperationBody();
        body.setDiscriminant(OperationType.CLAWBACK_CLAIMABLE_BALANCE);
        body.setClawbackClaimableBalanceOp(op);
        return body;
    }

    @Generated
    protected ClawbackClaimableBalanceOperation(ClawbackClaimableBalanceOperationBuilder<?, ?> b) {
        super(b);
        this.balanceId = ((ClawbackClaimableBalanceOperationBuilder)b).balanceId;
        if (this.balanceId == null) {
            throw new NullPointerException("balanceId is marked non-null but is null");
        }
    }

    @Generated
    public static ClawbackClaimableBalanceOperationBuilder<?, ?> builder() {
        return new ClawbackClaimableBalanceOperationBuilderImpl();
    }

    @Generated
    public ClawbackClaimableBalanceOperationBuilder<?, ?> toBuilder() {
        return new ClawbackClaimableBalanceOperationBuilderImpl().$fillValuesFrom(this);
    }

    @NonNull
    @Generated
    public String getBalanceId() {
        return this.balanceId;
    }

    @Generated
    public String toString() {
        return "ClawbackClaimableBalanceOperation(super=" + super.toString() + ", balanceId=" + this.getBalanceId() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClawbackClaimableBalanceOperation)) {
            return false;
        }
        ClawbackClaimableBalanceOperation other = (ClawbackClaimableBalanceOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$balanceId = this.getBalanceId();
        String other$balanceId = other.getBalanceId();
        return !(this$balanceId == null ? other$balanceId != null : !this$balanceId.equals(other$balanceId));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClawbackClaimableBalanceOperation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $balanceId = this.getBalanceId();
        result = result * 59 + ($balanceId == null ? 43 : $balanceId.hashCode());
        return result;
    }

    @Generated
    private ClawbackClaimableBalanceOperation(@NonNull String balanceId) {
        if (balanceId == null) {
            throw new NullPointerException("balanceId is marked non-null but is null");
        }
        this.balanceId = balanceId;
    }

    public static abstract class ClawbackClaimableBalanceOperationBuilder<C extends ClawbackClaimableBalanceOperation, B extends ClawbackClaimableBalanceOperationBuilder<C, B>>
    extends Operation.OperationBuilder<C, B> {
        @Generated
        private String balanceId;

        public B balanceId(@NonNull String balanceId) {
            if (balanceId == null) {
                throw new NullPointerException("balanceId is marked non-null but is null");
            }
            this.balanceId = balanceId.toLowerCase();
            return (B)this.self();
        }

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ClawbackClaimableBalanceOperationBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ClawbackClaimableBalanceOperation instance, ClawbackClaimableBalanceOperationBuilder<?, ?> b) {
            b.balanceId(instance.balanceId);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "ClawbackClaimableBalanceOperation.ClawbackClaimableBalanceOperationBuilder(super=" + super.toString() + ", balanceId=" + this.balanceId + ")";
        }
    }

    @Generated
    private static final class ClawbackClaimableBalanceOperationBuilderImpl
    extends ClawbackClaimableBalanceOperationBuilder<ClawbackClaimableBalanceOperation, ClawbackClaimableBalanceOperationBuilderImpl> {
        @Generated
        private ClawbackClaimableBalanceOperationBuilderImpl() {
        }

        @Override
        @Generated
        protected ClawbackClaimableBalanceOperationBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ClawbackClaimableBalanceOperation build() {
            return new ClawbackClaimableBalanceOperation(this);
        }
    }
}

