/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.stellar.sdk.Asset;
import org.stellar.sdk.AssetTypeCreditAlphaNum;
import org.stellar.sdk.AssetTypeNative;
import org.stellar.sdk.exception.ConnectionErrorException;
import org.stellar.sdk.exception.RequestTimeoutException;
import org.stellar.sdk.requests.ResponseHandler;

public abstract class RequestBuilder {
    protected HttpUrl.Builder uriBuilder;
    protected OkHttpClient httpClient;
    private final ArrayList<String> segments;
    private boolean segmentsAdded;

    RequestBuilder(OkHttpClient httpClient, HttpUrl serverURI, String defaultSegment) {
        this.httpClient = httpClient;
        this.uriBuilder = serverURI.newBuilder();
        this.segments = new ArrayList();
        if (defaultSegment != null) {
            this.setSegments(defaultSegment);
        }
        this.segmentsAdded = false;
    }

    protected RequestBuilder setSegments(String ... segments) {
        if (this.segmentsAdded) {
            throw new IllegalArgumentException("URL segments have been already added.");
        }
        this.segmentsAdded = true;
        this.segments.clear();
        this.segments.addAll(Arrays.asList(segments));
        return this;
    }

    public RequestBuilder cursor(String cursor) {
        this.uriBuilder.setQueryParameter("cursor", cursor);
        return this;
    }

    public RequestBuilder limit(int number) {
        this.uriBuilder.setQueryParameter("limit", String.valueOf(number));
        return this;
    }

    public RequestBuilder order(Order direction) {
        this.uriBuilder.setQueryParameter("order", direction.getValue());
        return this;
    }

    public void setAssetsParameter(String name, List<Asset> assets) {
        ArrayList<String> assetStrings = new ArrayList<String>();
        for (Asset asset : assets) {
            assetStrings.add(this.encodeAsset(asset));
        }
        this.uriBuilder.setQueryParameter(name, String.join((CharSequence)",", assetStrings));
    }

    public void setAssetParameter(String name, Asset asset) {
        this.uriBuilder.setQueryParameter(name, this.encodeAsset(asset));
    }

    private String encodeAsset(Asset asset) {
        if (asset instanceof AssetTypeNative) {
            return "native";
        }
        if (asset instanceof AssetTypeCreditAlphaNum) {
            AssetTypeCreditAlphaNum creditAsset = (AssetTypeCreditAlphaNum)asset;
            return creditAsset.getCode() + ":" + creditAsset.getIssuer();
        }
        throw new IllegalArgumentException("unsupported asset " + asset.getType());
    }

    HttpUrl buildUri() {
        if (!this.segments.isEmpty()) {
            for (String segment : this.segments) {
                this.uriBuilder.addPathSegment(segment);
            }
        }
        return this.uriBuilder.build();
    }

    static <T> T executeGetRequest(OkHttpClient httpClient, HttpUrl url, TypeToken<T> typeToken) {
        Response response;
        ResponseHandler<T> responseHandler = new ResponseHandler<T>(typeToken);
        Request request = new Request.Builder().get().url(url).build();
        try {
            response = httpClient.newCall(request).execute();
        }
        catch (SocketTimeoutException e) {
            throw new RequestTimeoutException(e);
        }
        catch (IOException e) {
            throw new ConnectionErrorException(e);
        }
        return responseHandler.handleResponse(response);
    }

    static String getAssetType(Asset asset) {
        String assetType;
        switch (asset.getType()) {
            case ASSET_TYPE_NATIVE: {
                assetType = "native";
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM4: {
                assetType = "credit_alphanum4";
                break;
            }
            case ASSET_TYPE_CREDIT_ALPHANUM12: {
                assetType = "credit_alphanum12";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid asset type");
            }
        }
        return assetType;
    }

    public static enum Order {
        ASC("asc"),
        DESC("desc");

        private final String value;

        private Order(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

