/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import okhttp3.Response;
import org.stellar.sdk.exception.BadRequestException;
import org.stellar.sdk.exception.BadResponseException;
import org.stellar.sdk.exception.RequestTimeoutException;
import org.stellar.sdk.exception.TooManyRequestsException;
import org.stellar.sdk.exception.UnexpectedException;
import org.stellar.sdk.exception.UnknownResponseException;
import org.stellar.sdk.responses.Problem;
import org.stellar.sdk.responses.SubmitTransactionAsyncResponse;
import org.stellar.sdk.responses.gson.GsonSingleton;
import org.stellar.sdk.responses.gson.TypedResponse;

public class ResponseHandler<T> {
    private final TypeToken<T> type;

    public ResponseHandler(TypeToken<T> type) {
        this.type = type;
    }

    public T handleResponse(Response response) {
        return this.handleResponse(response, false);
    }

    public T handleResponse(Response response, boolean submitTransactionAsync) {
        try {
            if (response.code() == 429) {
                Integer retryAfter = null;
                String header = response.header("Retry-After");
                if (header != null) {
                    try {
                        retryAfter = Integer.parseInt(header);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                throw new TooManyRequestsException(retryAfter);
            }
            String content = null;
            if (response.body() == null) {
                throw new UnexpectedException("Unexpected empty response body");
            }
            try {
                content = response.body().string();
            }
            catch (IOException e) {
                throw new UnexpectedException("Unexpected error reading response", e);
            }
            if (response.code() >= 200 && response.code() < 300) {
                Object object = GsonSingleton.getInstance().fromJson(content, this.type.getType());
                if (object instanceof TypedResponse) {
                    ((TypedResponse)object).setType(this.type);
                }
                Object object2 = object;
                return (T)object2;
            }
            if (response.code() >= 400 && response.code() < 600) {
                Problem problem = null;
                SubmitTransactionAsyncResponse submitTransactionAsyncProblem = null;
                try {
                    problem = (Problem)GsonSingleton.getInstance().fromJson(content, Problem.class);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (submitTransactionAsync) {
                    try {
                        submitTransactionAsyncProblem = (SubmitTransactionAsyncResponse)GsonSingleton.getInstance().fromJson(content, SubmitTransactionAsyncResponse.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (response.code() == 504) {
                    throw new RequestTimeoutException(response.code(), content, problem);
                }
                if (response.code() < 500) {
                    throw new BadRequestException(response.code(), content, problem, submitTransactionAsyncProblem);
                }
                throw new BadResponseException(response.code(), content, problem, submitTransactionAsyncProblem);
            }
            throw new UnknownResponseException(response.code(), content);
        }
        finally {
            response.close();
        }
    }
}

