/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.requests;

import com.google.gson.reflect.TypeToken;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.stellar.sdk.requests.EventListener;
import org.stellar.sdk.requests.RequestBuilder;
import org.stellar.sdk.requests.SSEStream;
import org.stellar.sdk.responses.Page;
import org.stellar.sdk.responses.TransactionResponse;

public class TransactionsRequestBuilder
extends RequestBuilder {
    public TransactionsRequestBuilder(OkHttpClient httpClient, HttpUrl serverURI) {
        super(httpClient, serverURI, "transactions");
    }

    public TransactionResponse transaction(HttpUrl uri) {
        TypeToken<TransactionResponse> type = new TypeToken<TransactionResponse>(){};
        return TransactionsRequestBuilder.executeGetRequest(this.httpClient, uri, type);
    }

    public TransactionResponse transaction(String transactionId) {
        this.setSegments("transactions", transactionId);
        return this.transaction(this.buildUri());
    }

    public TransactionsRequestBuilder forAccount(@NonNull String account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        this.setSegments("accounts", account, "transactions");
        return this;
    }

    public TransactionsRequestBuilder forClaimableBalance(@NonNull String claimableBalance) {
        if (claimableBalance == null) {
            throw new NullPointerException("claimableBalance is marked non-null but is null");
        }
        this.setSegments("claimable_balances", claimableBalance, "transactions");
        return this;
    }

    public TransactionsRequestBuilder forLedger(long ledgerSeq) {
        this.setSegments("ledgers", String.valueOf(ledgerSeq), "transactions");
        return this;
    }

    public TransactionsRequestBuilder forLiquidityPool(String liquidityPoolId) {
        this.setSegments("liquidity_pools", liquidityPoolId, "transactions");
        return this;
    }

    public TransactionsRequestBuilder includeFailed(boolean value) {
        this.uriBuilder.setQueryParameter("include_failed", String.valueOf(value));
        return this;
    }

    public static Page<TransactionResponse> execute(OkHttpClient httpClient, HttpUrl uri) {
        TypeToken<Page<TransactionResponse>> type = new TypeToken<Page<TransactionResponse>>(){};
        return TransactionsRequestBuilder.executeGetRequest(httpClient, uri, type);
    }

    public SSEStream<TransactionResponse> stream(EventListener<TransactionResponse> listener, long reconnectTimeout) {
        return SSEStream.create(this.httpClient, this, TransactionResponse.class, listener, reconnectTimeout);
    }

    public SSEStream<TransactionResponse> stream(EventListener<TransactionResponse> listener) {
        return this.stream(listener, 15000L);
    }

    public Page<TransactionResponse> execute() {
        return TransactionsRequestBuilder.execute(this.httpClient, this.buildUri());
    }

    @Override
    public TransactionsRequestBuilder cursor(String token) {
        super.cursor(token);
        return this;
    }

    @Override
    public TransactionsRequestBuilder limit(int number) {
        super.limit(number);
        return this;
    }

    @Override
    public TransactionsRequestBuilder order(RequestBuilder.Order direction) {
        super.order(direction);
        return this;
    }
}

