/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.responses.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Optional;
import org.stellar.sdk.Asset;

class AssetDeserializer
implements JsonDeserializer<Asset> {
    AssetDeserializer() {
    }

    public Asset deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            return Asset.create(json.getAsString());
        }
        return Asset.create(json.getAsJsonObject().get("asset_type").getAsString(), this.getValueAsString(json.getAsJsonObject().get("asset_code")), this.getValueAsString(json.getAsJsonObject().get("asset_issuer")));
    }

    private String getValueAsString(JsonElement element) {
        return Optional.ofNullable(element).map(JsonElement::getAsString).orElse(null);
    }
}

