/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum BucketEntryType implements XdrElement
{
    METAENTRY(-1),
    LIVEENTRY(0),
    DEADENTRY(1),
    INITENTRY(2);

    private final int value;

    private BucketEntryType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BucketEntryType decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case -1: {
                return METAENTRY;
            }
            case 0: {
                return LIVEENTRY;
            }
            case 1: {
                return DEADENTRY;
            }
            case 2: {
                return INITENTRY;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static BucketEntryType fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return BucketEntryType.fromXdrByteArray(bytes);
    }

    public static BucketEntryType fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return BucketEntryType.decode(xdrDataInputStream);
    }
}

