/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class HmacSha256Mac
implements XdrElement {
    private byte[] mac;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        int macSize = this.mac.length;
        stream.write(this.getMac(), 0, macSize);
    }

    public static HmacSha256Mac decode(XdrDataInputStream stream) throws IOException {
        HmacSha256Mac decodedHmacSha256Mac = new HmacSha256Mac();
        int macSize = 32;
        decodedHmacSha256Mac.mac = new byte[macSize];
        stream.read(decodedHmacSha256Mac.mac, 0, macSize);
        return decodedHmacSha256Mac;
    }

    public static HmacSha256Mac fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return HmacSha256Mac.fromXdrByteArray(bytes);
    }

    public static HmacSha256Mac fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return HmacSha256Mac.decode(xdrDataInputStream);
    }

    @Generated
    public static HmacSha256MacBuilder builder() {
        return new HmacSha256MacBuilder();
    }

    @Generated
    public HmacSha256MacBuilder toBuilder() {
        return new HmacSha256MacBuilder().mac(this.mac);
    }

    @Generated
    public byte[] getMac() {
        return this.mac;
    }

    @Generated
    public void setMac(byte[] mac) {
        this.mac = mac;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HmacSha256Mac)) {
            return false;
        }
        HmacSha256Mac other = (HmacSha256Mac)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.getMac(), other.getMac());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HmacSha256Mac;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getMac());
        return result;
    }

    @Generated
    public String toString() {
        return "HmacSha256Mac(mac=" + Arrays.toString(this.getMac()) + ")";
    }

    @Generated
    public HmacSha256Mac() {
    }

    @Generated
    public HmacSha256Mac(byte[] mac) {
        this.mac = mac;
    }

    @Generated
    public static class HmacSha256MacBuilder {
        @Generated
        private byte[] mac;

        @Generated
        HmacSha256MacBuilder() {
        }

        @Generated
        public HmacSha256MacBuilder mac(byte[] mac) {
            this.mac = mac;
            return this;
        }

        @Generated
        public HmacSha256Mac build() {
            return new HmacSha256Mac(this.mac);
        }

        @Generated
        public String toString() {
            return "HmacSha256Mac.HmacSha256MacBuilder(mac=" + Arrays.toString(this.mac) + ")";
        }
    }
}

