/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public enum RevokeSponsorshipResultCode implements XdrElement
{
    REVOKE_SPONSORSHIP_SUCCESS(0),
    REVOKE_SPONSORSHIP_DOES_NOT_EXIST(-1),
    REVOKE_SPONSORSHIP_NOT_SPONSOR(-2),
    REVOKE_SPONSORSHIP_LOW_RESERVE(-3),
    REVOKE_SPONSORSHIP_ONLY_TRANSFERABLE(-4),
    REVOKE_SPONSORSHIP_MALFORMED(-5);

    private final int value;

    private RevokeSponsorshipResultCode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RevokeSponsorshipResultCode decode(XdrDataInputStream stream) throws IOException {
        int value = stream.readInt();
        switch (value) {
            case 0: {
                return REVOKE_SPONSORSHIP_SUCCESS;
            }
            case -1: {
                return REVOKE_SPONSORSHIP_DOES_NOT_EXIST;
            }
            case -2: {
                return REVOKE_SPONSORSHIP_NOT_SPONSOR;
            }
            case -3: {
                return REVOKE_SPONSORSHIP_LOW_RESERVE;
            }
            case -4: {
                return REVOKE_SPONSORSHIP_ONLY_TRANSFERABLE;
            }
            case -5: {
                return REVOKE_SPONSORSHIP_MALFORMED;
            }
        }
        throw new IllegalArgumentException("Unknown enum value: " + value);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.value);
    }

    public static RevokeSponsorshipResultCode fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return RevokeSponsorshipResultCode.fromXdrByteArray(bytes);
    }

    public static RevokeSponsorshipResultCode fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return RevokeSponsorshipResultCode.decode(xdrDataInputStream);
    }
}

