/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.PeerStatList;
import org.stellar.sdk.xdr.Uint32;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public class TopologyResponseBodyV1
implements XdrElement {
    private PeerStatList inboundPeers;
    private PeerStatList outboundPeers;
    private Uint32 totalInboundPeerCount;
    private Uint32 totalOutboundPeerCount;
    private Uint32 maxInboundPeerCount;
    private Uint32 maxOutboundPeerCount;

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        this.inboundPeers.encode(stream);
        this.outboundPeers.encode(stream);
        this.totalInboundPeerCount.encode(stream);
        this.totalOutboundPeerCount.encode(stream);
        this.maxInboundPeerCount.encode(stream);
        this.maxOutboundPeerCount.encode(stream);
    }

    public static TopologyResponseBodyV1 decode(XdrDataInputStream stream) throws IOException {
        TopologyResponseBodyV1 decodedTopologyResponseBodyV1 = new TopologyResponseBodyV1();
        decodedTopologyResponseBodyV1.inboundPeers = PeerStatList.decode(stream);
        decodedTopologyResponseBodyV1.outboundPeers = PeerStatList.decode(stream);
        decodedTopologyResponseBodyV1.totalInboundPeerCount = Uint32.decode(stream);
        decodedTopologyResponseBodyV1.totalOutboundPeerCount = Uint32.decode(stream);
        decodedTopologyResponseBodyV1.maxInboundPeerCount = Uint32.decode(stream);
        decodedTopologyResponseBodyV1.maxOutboundPeerCount = Uint32.decode(stream);
        return decodedTopologyResponseBodyV1;
    }

    public static TopologyResponseBodyV1 fromXdrBase64(String xdr) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return TopologyResponseBodyV1.fromXdrByteArray(bytes);
    }

    public static TopologyResponseBodyV1 fromXdrByteArray(byte[] xdr) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return TopologyResponseBodyV1.decode(xdrDataInputStream);
    }

    @Generated
    public static TopologyResponseBodyV1Builder builder() {
        return new TopologyResponseBodyV1Builder();
    }

    @Generated
    public TopologyResponseBodyV1Builder toBuilder() {
        return new TopologyResponseBodyV1Builder().inboundPeers(this.inboundPeers).outboundPeers(this.outboundPeers).totalInboundPeerCount(this.totalInboundPeerCount).totalOutboundPeerCount(this.totalOutboundPeerCount).maxInboundPeerCount(this.maxInboundPeerCount).maxOutboundPeerCount(this.maxOutboundPeerCount);
    }

    @Generated
    public PeerStatList getInboundPeers() {
        return this.inboundPeers;
    }

    @Generated
    public PeerStatList getOutboundPeers() {
        return this.outboundPeers;
    }

    @Generated
    public Uint32 getTotalInboundPeerCount() {
        return this.totalInboundPeerCount;
    }

    @Generated
    public Uint32 getTotalOutboundPeerCount() {
        return this.totalOutboundPeerCount;
    }

    @Generated
    public Uint32 getMaxInboundPeerCount() {
        return this.maxInboundPeerCount;
    }

    @Generated
    public Uint32 getMaxOutboundPeerCount() {
        return this.maxOutboundPeerCount;
    }

    @Generated
    public void setInboundPeers(PeerStatList inboundPeers) {
        this.inboundPeers = inboundPeers;
    }

    @Generated
    public void setOutboundPeers(PeerStatList outboundPeers) {
        this.outboundPeers = outboundPeers;
    }

    @Generated
    public void setTotalInboundPeerCount(Uint32 totalInboundPeerCount) {
        this.totalInboundPeerCount = totalInboundPeerCount;
    }

    @Generated
    public void setTotalOutboundPeerCount(Uint32 totalOutboundPeerCount) {
        this.totalOutboundPeerCount = totalOutboundPeerCount;
    }

    @Generated
    public void setMaxInboundPeerCount(Uint32 maxInboundPeerCount) {
        this.maxInboundPeerCount = maxInboundPeerCount;
    }

    @Generated
    public void setMaxOutboundPeerCount(Uint32 maxOutboundPeerCount) {
        this.maxOutboundPeerCount = maxOutboundPeerCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopologyResponseBodyV1)) {
            return false;
        }
        TopologyResponseBodyV1 other = (TopologyResponseBodyV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PeerStatList this$inboundPeers = this.getInboundPeers();
        PeerStatList other$inboundPeers = other.getInboundPeers();
        if (this$inboundPeers == null ? other$inboundPeers != null : !((Object)this$inboundPeers).equals(other$inboundPeers)) {
            return false;
        }
        PeerStatList this$outboundPeers = this.getOutboundPeers();
        PeerStatList other$outboundPeers = other.getOutboundPeers();
        if (this$outboundPeers == null ? other$outboundPeers != null : !((Object)this$outboundPeers).equals(other$outboundPeers)) {
            return false;
        }
        Uint32 this$totalInboundPeerCount = this.getTotalInboundPeerCount();
        Uint32 other$totalInboundPeerCount = other.getTotalInboundPeerCount();
        if (this$totalInboundPeerCount == null ? other$totalInboundPeerCount != null : !((Object)this$totalInboundPeerCount).equals(other$totalInboundPeerCount)) {
            return false;
        }
        Uint32 this$totalOutboundPeerCount = this.getTotalOutboundPeerCount();
        Uint32 other$totalOutboundPeerCount = other.getTotalOutboundPeerCount();
        if (this$totalOutboundPeerCount == null ? other$totalOutboundPeerCount != null : !((Object)this$totalOutboundPeerCount).equals(other$totalOutboundPeerCount)) {
            return false;
        }
        Uint32 this$maxInboundPeerCount = this.getMaxInboundPeerCount();
        Uint32 other$maxInboundPeerCount = other.getMaxInboundPeerCount();
        if (this$maxInboundPeerCount == null ? other$maxInboundPeerCount != null : !((Object)this$maxInboundPeerCount).equals(other$maxInboundPeerCount)) {
            return false;
        }
        Uint32 this$maxOutboundPeerCount = this.getMaxOutboundPeerCount();
        Uint32 other$maxOutboundPeerCount = other.getMaxOutboundPeerCount();
        return !(this$maxOutboundPeerCount == null ? other$maxOutboundPeerCount != null : !((Object)this$maxOutboundPeerCount).equals(other$maxOutboundPeerCount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopologyResponseBodyV1;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PeerStatList $inboundPeers = this.getInboundPeers();
        result = result * 59 + ($inboundPeers == null ? 43 : ((Object)$inboundPeers).hashCode());
        PeerStatList $outboundPeers = this.getOutboundPeers();
        result = result * 59 + ($outboundPeers == null ? 43 : ((Object)$outboundPeers).hashCode());
        Uint32 $totalInboundPeerCount = this.getTotalInboundPeerCount();
        result = result * 59 + ($totalInboundPeerCount == null ? 43 : ((Object)$totalInboundPeerCount).hashCode());
        Uint32 $totalOutboundPeerCount = this.getTotalOutboundPeerCount();
        result = result * 59 + ($totalOutboundPeerCount == null ? 43 : ((Object)$totalOutboundPeerCount).hashCode());
        Uint32 $maxInboundPeerCount = this.getMaxInboundPeerCount();
        result = result * 59 + ($maxInboundPeerCount == null ? 43 : ((Object)$maxInboundPeerCount).hashCode());
        Uint32 $maxOutboundPeerCount = this.getMaxOutboundPeerCount();
        result = result * 59 + ($maxOutboundPeerCount == null ? 43 : ((Object)$maxOutboundPeerCount).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TopologyResponseBodyV1(inboundPeers=" + this.getInboundPeers() + ", outboundPeers=" + this.getOutboundPeers() + ", totalInboundPeerCount=" + this.getTotalInboundPeerCount() + ", totalOutboundPeerCount=" + this.getTotalOutboundPeerCount() + ", maxInboundPeerCount=" + this.getMaxInboundPeerCount() + ", maxOutboundPeerCount=" + this.getMaxOutboundPeerCount() + ")";
    }

    @Generated
    public TopologyResponseBodyV1() {
    }

    @Generated
    public TopologyResponseBodyV1(PeerStatList inboundPeers, PeerStatList outboundPeers, Uint32 totalInboundPeerCount, Uint32 totalOutboundPeerCount, Uint32 maxInboundPeerCount, Uint32 maxOutboundPeerCount) {
        this.inboundPeers = inboundPeers;
        this.outboundPeers = outboundPeers;
        this.totalInboundPeerCount = totalInboundPeerCount;
        this.totalOutboundPeerCount = totalOutboundPeerCount;
        this.maxInboundPeerCount = maxInboundPeerCount;
        this.maxOutboundPeerCount = maxOutboundPeerCount;
    }

    @Generated
    public static class TopologyResponseBodyV1Builder {
        @Generated
        private PeerStatList inboundPeers;
        @Generated
        private PeerStatList outboundPeers;
        @Generated
        private Uint32 totalInboundPeerCount;
        @Generated
        private Uint32 totalOutboundPeerCount;
        @Generated
        private Uint32 maxInboundPeerCount;
        @Generated
        private Uint32 maxOutboundPeerCount;

        @Generated
        TopologyResponseBodyV1Builder() {
        }

        @Generated
        public TopologyResponseBodyV1Builder inboundPeers(PeerStatList inboundPeers) {
            this.inboundPeers = inboundPeers;
            return this;
        }

        @Generated
        public TopologyResponseBodyV1Builder outboundPeers(PeerStatList outboundPeers) {
            this.outboundPeers = outboundPeers;
            return this;
        }

        @Generated
        public TopologyResponseBodyV1Builder totalInboundPeerCount(Uint32 totalInboundPeerCount) {
            this.totalInboundPeerCount = totalInboundPeerCount;
            return this;
        }

        @Generated
        public TopologyResponseBodyV1Builder totalOutboundPeerCount(Uint32 totalOutboundPeerCount) {
            this.totalOutboundPeerCount = totalOutboundPeerCount;
            return this;
        }

        @Generated
        public TopologyResponseBodyV1Builder maxInboundPeerCount(Uint32 maxInboundPeerCount) {
            this.maxInboundPeerCount = maxInboundPeerCount;
            return this;
        }

        @Generated
        public TopologyResponseBodyV1Builder maxOutboundPeerCount(Uint32 maxOutboundPeerCount) {
            this.maxOutboundPeerCount = maxOutboundPeerCount;
            return this;
        }

        @Generated
        public TopologyResponseBodyV1 build() {
            return new TopologyResponseBodyV1(this.inboundPeers, this.outboundPeers, this.totalInboundPeerCount, this.totalOutboundPeerCount, this.maxInboundPeerCount, this.maxOutboundPeerCount);
        }

        @Generated
        public String toString() {
            return "TopologyResponseBodyV1.TopologyResponseBodyV1Builder(inboundPeers=" + this.inboundPeers + ", outboundPeers=" + this.outboundPeers + ", totalInboundPeerCount=" + this.totalInboundPeerCount + ", totalOutboundPeerCount=" + this.totalOutboundPeerCount + ", maxInboundPeerCount=" + this.maxInboundPeerCount + ", maxOutboundPeerCount=" + this.maxOutboundPeerCount + ")";
        }
    }
}

