/*
 * Decompiled with CFR 0.152.
 */
package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.stellar.sdk.Base64Factory;
import org.stellar.sdk.xdr.XdrDataInputStream;
import org.stellar.sdk.xdr.XdrDataOutputStream;
import org.stellar.sdk.xdr.XdrElement;

public final class XdrString
implements XdrElement {
    private final byte[] bytes;

    public XdrString(byte[] bytes) {
        this.bytes = bytes;
    }

    public XdrString(String text) {
        this.bytes = text.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void encode(XdrDataOutputStream stream) throws IOException {
        stream.writeInt(this.bytes.length);
        stream.write(this.bytes, 0, this.bytes.length);
    }

    public static XdrString decode(XdrDataInputStream stream, int maxSize) throws IOException {
        int size = stream.readInt();
        if (size > maxSize) {
            throw new IllegalArgumentException("String length " + size + " exceeds max size " + maxSize);
        }
        byte[] bytes = new byte[size];
        stream.read(bytes);
        return new XdrString(bytes);
    }

    public static XdrString fromXdrBase64(String xdr, int maxSize) throws IOException {
        byte[] bytes = Base64Factory.getInstance().decode(xdr);
        return XdrString.fromXdrByteArray(bytes, maxSize);
    }

    public static XdrString fromXdrBase64(String xdr) throws IOException {
        return XdrString.fromXdrBase64(xdr, Integer.MAX_VALUE);
    }

    public static XdrString fromXdrByteArray(byte[] xdr, int maxSize) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
        XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
        return XdrString.decode(xdrDataInputStream, maxSize);
    }

    public static XdrString fromXdrByteArray(byte[] xdr) throws IOException {
        return XdrString.fromXdrByteArray(xdr, Integer.MAX_VALUE);
    }

    public String toString() {
        return new String(this.bytes, StandardCharsets.UTF_8);
    }

    @Generated
    public byte[] getBytes() {
        return this.bytes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XdrString)) {
            return false;
        }
        XdrString other = (XdrString)o;
        return Arrays.equals(this.getBytes(), other.getBytes());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getBytes());
        return result;
    }
}

