// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * BucketEntry's original definition in the XDR file is:
 *
 * <pre>
 * union BucketEntry switch (BucketEntryType type)
 * {
 * case LIVEENTRY:
 * case INITENTRY:
 *     LedgerEntry liveEntry;
 *
 * case DEADENTRY:
 *     LedgerKey deadEntry;
 * case METAENTRY:
 *     BucketMetadata metaEntry;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class BucketEntry implements XdrElement {
  private BucketEntryType discriminant;
  private LedgerEntry liveEntry;
  private LedgerKey deadEntry;
  private BucketMetadata metaEntry;

  public void encode(XdrDataOutputStream stream) throws IOException {
    stream.writeInt(discriminant.getValue());
    switch (discriminant) {
      case LIVEENTRY:
      case INITENTRY:
        liveEntry.encode(stream);
        break;
      case DEADENTRY:
        deadEntry.encode(stream);
        break;
      case METAENTRY:
        metaEntry.encode(stream);
        break;
    }
  }

  public static BucketEntry decode(XdrDataInputStream stream) throws IOException {
    BucketEntry decodedBucketEntry = new BucketEntry();
    BucketEntryType discriminant = BucketEntryType.decode(stream);
    decodedBucketEntry.setDiscriminant(discriminant);
    switch (decodedBucketEntry.getDiscriminant()) {
      case LIVEENTRY:
      case INITENTRY:
        decodedBucketEntry.liveEntry = LedgerEntry.decode(stream);
        break;
      case DEADENTRY:
        decodedBucketEntry.deadEntry = LedgerKey.decode(stream);
        break;
      case METAENTRY:
        decodedBucketEntry.metaEntry = BucketMetadata.decode(stream);
        break;
    }
    return decodedBucketEntry;
  }

  public static BucketEntry fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static BucketEntry fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
