// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * DataValue's original definition in the XDR file is:
 *
 * <pre>
 * typedef opaque DataValue&lt;64&gt;;
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DataValue implements XdrElement {
  private byte[] DataValue;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int DataValueSize = DataValue.length;
    stream.writeInt(DataValueSize);
    stream.write(getDataValue(), 0, DataValueSize);
  }

  public static DataValue decode(XdrDataInputStream stream) throws IOException {
    DataValue decodedDataValue = new DataValue();
    int DataValueSize = stream.readInt();
    decodedDataValue.DataValue = new byte[DataValueSize];
    stream.read(decodedDataValue.DataValue, 0, DataValueSize);
    return decodedDataValue;
  }

  public static DataValue fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static DataValue fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
