// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * EncryptedBody's original definition in the XDR file is:
 *
 * <pre>
 * typedef opaque EncryptedBody&lt;64000&gt;;
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class EncryptedBody implements XdrElement {
  private byte[] EncryptedBody;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int EncryptedBodySize = EncryptedBody.length;
    stream.writeInt(EncryptedBodySize);
    stream.write(getEncryptedBody(), 0, EncryptedBodySize);
  }

  public static EncryptedBody decode(XdrDataInputStream stream) throws IOException {
    EncryptedBody decodedEncryptedBody = new EncryptedBody();
    int EncryptedBodySize = stream.readInt();
    decodedEncryptedBody.EncryptedBody = new byte[EncryptedBodySize];
    stream.read(decodedEncryptedBody.EncryptedBody, 0, EncryptedBodySize);
    return decodedEncryptedBody;
  }

  public static EncryptedBody fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static EncryptedBody fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
