// Automatically generated by xdrgen
// DO NOT EDIT or your changes may be overwritten

package org.stellar.sdk.xdr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.stellar.sdk.Base64Factory;

/**
 * LedgerFootprint's original definition in the XDR file is:
 *
 * <pre>
 * struct LedgerFootprint
 * {
 *     LedgerKey readOnly&lt;&gt;;
 *     LedgerKey readWrite&lt;&gt;;
 * };
 * </pre>
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder(toBuilder = true)
public class LedgerFootprint implements XdrElement {
  private LedgerKey[] readOnly;
  private LedgerKey[] readWrite;

  public void encode(XdrDataOutputStream stream) throws IOException {
    int readOnlySize = getReadOnly().length;
    stream.writeInt(readOnlySize);
    for (int i = 0; i < readOnlySize; i++) {
      readOnly[i].encode(stream);
    }
    int readWriteSize = getReadWrite().length;
    stream.writeInt(readWriteSize);
    for (int i = 0; i < readWriteSize; i++) {
      readWrite[i].encode(stream);
    }
  }

  public static LedgerFootprint decode(XdrDataInputStream stream) throws IOException {
    LedgerFootprint decodedLedgerFootprint = new LedgerFootprint();
    int readOnlySize = stream.readInt();
    decodedLedgerFootprint.readOnly = new LedgerKey[readOnlySize];
    for (int i = 0; i < readOnlySize; i++) {
      decodedLedgerFootprint.readOnly[i] = LedgerKey.decode(stream);
    }
    int readWriteSize = stream.readInt();
    decodedLedgerFootprint.readWrite = new LedgerKey[readWriteSize];
    for (int i = 0; i < readWriteSize; i++) {
      decodedLedgerFootprint.readWrite[i] = LedgerKey.decode(stream);
    }
    return decodedLedgerFootprint;
  }

  public static LedgerFootprint fromXdrBase64(String xdr) throws IOException {
    byte[] bytes = Base64Factory.getInstance().decode(xdr);
    return fromXdrByteArray(bytes);
  }

  public static LedgerFootprint fromXdrByteArray(byte[] xdr) throws IOException {
    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xdr);
    XdrDataInputStream xdrDataInputStream = new XdrDataInputStream(byteArrayInputStream);
    return decode(xdrDataInputStream);
  }
}
